/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.restlet.engine.http.io.ChunkedInputStream;
import org.restlet.engine.http.io.ChunkedOutputStream;
import org.restlet.test.RestletTestCase;

public class ChunkedInputStreamTestCase
extends RestletTestCase {
    private String read(InputStream input) throws IOException {
        byte[] buffer = new byte[1024];
        StringBuilder result = new StringBuilder();
        int bytesRead = input.read(buffer);
        while (bytesRead != -1) {
            result.append(new String(buffer, 0, bytesRead));
            bytesRead = input.read(buffer);
        }
        return result.toString();
    }

    public void testClose() throws IOException {
        String data = "test data";
        InputStream input = this.write("test data");
        ChunkedInputStream chunked = new ChunkedInputStream(null, input);
        ChunkedInputStreamTestCase.assertEquals((int)116, (int)chunked.read());
        chunked.close();
        ChunkedInputStreamTestCase.assertEquals((int)-1, (int)chunked.read());
        input = this.write("test data");
        chunked = new ChunkedInputStream(null, input);
        chunked.close();
        ChunkedInputStreamTestCase.assertEquals((int)-1, (int)chunked.read());
    }

    public void testRead() throws IOException {
        String data = "test data";
        InputStream input = this.write(data);
        ChunkedInputStream chunked = new ChunkedInputStream(null, input);
        ChunkedInputStreamTestCase.assertEquals((String)data, (String)this.read((InputStream)chunked));
        input = new ByteArrayInputStream("1a; ignore-stuff-here\r\nabcdefghijklmnopqrstuvwxyz\r\n10; other stuff\r\n1234567890abcdef\r\n0\r\n\r\n".getBytes());
        chunked = new ChunkedInputStream(null, input);
        ChunkedInputStreamTestCase.assertEquals((String)"abcdefghijklmnopqrstuvwxyz1234567890abcdef", (String)this.read((InputStream)chunked));
        input = new ByteArrayInputStream("\r\n1a; ignore-stuff-here\r\nabcdefghijklmnopqrstuvwxyz\r\n10; other stuff\r\n1234567890abcdef\r\n0\r\n\r\n".getBytes());
        chunked = new ChunkedInputStream(null, input);
        ChunkedInputStreamTestCase.assertEquals((String)"abcdefghijklmnopqrstuvwxyz1234567890abcdef", (String)this.read((InputStream)chunked));
        data = "";
        input = this.write(data);
        chunked = new ChunkedInputStream(null, input);
        ChunkedInputStreamTestCase.assertEquals((String)data, (String)this.read((InputStream)chunked));
        data = "\r\n";
        input = this.write(data);
        chunked = new ChunkedInputStream(null, input);
        ChunkedInputStreamTestCase.assertEquals((String)data, (String)this.read((InputStream)chunked));
    }

    public void testReadWithChunkSizeComments() throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream("9; comment\r\ntest data\r\n0\r\n\r\n".getBytes());
        ChunkedInputStream chunked = new ChunkedInputStream(null, (InputStream)input);
        ChunkedInputStreamTestCase.assertEquals((String)"test data", (String)this.read((InputStream)chunked));
        input = new ByteArrayInputStream("9 ; comment\r\ntest data\r\n0\r\n\r\n".getBytes());
        chunked = new ChunkedInputStream(null, (InputStream)input);
        ChunkedInputStreamTestCase.assertEquals((String)"test data", (String)this.read((InputStream)chunked));
        input = new ByteArrayInputStream("4; comment\r\ntest\r\n5; another comment\r\n data\r\n0\r\n\r\n".getBytes());
        chunked = new ChunkedInputStream(null, (InputStream)input);
        ChunkedInputStreamTestCase.assertEquals((String)"test data", (String)this.read((InputStream)chunked));
    }

    private InputStream write(String data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ChunkedOutputStream chunked = new ChunkedOutputStream((OutputStream)out, 2);
        chunked.write(data.getBytes());
        chunked.close();
        return new ByteArrayInputStream(out.toByteArray());
    }
}

