/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.security;

import java.util.Arrays;
import org.junit.After;
import org.junit.Before;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.security.ChallengeAuthenticator;
import org.restlet.security.MapVerifier;
import org.restlet.security.Verifier;
import org.restlet.test.RestletTestCase;

public class HttpBasicTestCase
extends RestletTestCase {
    public static final String WRONG_USERNAME = "wrongUser";
    public static final String SHORT_USERNAME = "user13";
    public static final String SHORT_PASSWORD = "pw15";
    public static final String LONG_USERNAME = "aVeryLongUsernameIsIndeedRequiredForThisTest";
    public static final String LONG_PASSWORD = "thisLongPasswordIsExtremelySecure";
    public static final String AUTHENTICATED_MSG = "You are authenticated";
    private Component component;
    private String uri;
    private ChallengeAuthenticator authenticator;
    private MapVerifier verifier;

    public static void main(String[] args) {
        new HttpBasicTestCase().testHTTPBasic();
    }

    public void guardLong() {
        HttpBasicTestCase.assertTrue((String)"Didn't authenticate short user/pwd", (boolean)this.verifier.verify(LONG_USERNAME, LONG_PASSWORD.toCharArray()));
    }

    public void guardLongWrong() {
        HttpBasicTestCase.assertFalse((String)"Authenticated long username with wrong password", (boolean)this.verifier.verify(LONG_USERNAME, SHORT_PASSWORD.toCharArray()));
    }

    public void guardShort() {
        HttpBasicTestCase.assertTrue((String)"Didn't authenticate short user/pwd", (boolean)this.verifier.verify(SHORT_USERNAME, SHORT_PASSWORD.toCharArray()));
    }

    public void guardShortWrong() {
        HttpBasicTestCase.assertFalse((String)"Authenticated short username with wrong password", (boolean)this.verifier.verify(SHORT_USERNAME, LONG_PASSWORD.toCharArray()));
    }

    public void guardWrongUser() {
        HttpBasicTestCase.assertFalse((String)"Authenticated wrong username", (boolean)this.verifier.verify(WRONG_USERNAME, SHORT_PASSWORD.toCharArray()));
    }

    public void HTTPBasicLong() throws Exception {
        Request request = new Request(Method.GET, this.uri);
        Client client = new Client(Protocol.HTTP);
        ChallengeResponse authentication = new ChallengeResponse(ChallengeScheme.HTTP_BASIC, LONG_USERNAME, LONG_PASSWORD);
        request.setChallengeResponse(authentication);
        Response response = client.handle(request);
        HttpBasicTestCase.assertEquals((String)"Long username did not return 200 OK", (Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HttpBasicTestCase.assertEquals((String)AUTHENTICATED_MSG, (String)response.getEntity().getText());
        client.stop();
    }

    public void HTTPBasicLongWrong() throws Exception {
        Request request = new Request(Method.GET, this.uri);
        Client client = new Client(Protocol.HTTP);
        ChallengeResponse authentication = new ChallengeResponse(ChallengeScheme.HTTP_BASIC, LONG_USERNAME, SHORT_PASSWORD);
        request.setChallengeResponse(authentication);
        Response response = client.handle(request);
        HttpBasicTestCase.assertEquals((String)"Long username w/wrong pw did not throw 403", (Object)Status.CLIENT_ERROR_UNAUTHORIZED, (Object)response.getStatus());
        client.stop();
    }

    public void HTTPBasicNone() throws Exception {
        Request request = new Request(Method.GET, this.uri);
        Client client = new Client(Protocol.HTTP);
        Response response = client.handle(request);
        HttpBasicTestCase.assertEquals((String)"No user did not throw 401", (Object)Status.CLIENT_ERROR_UNAUTHORIZED, (Object)response.getStatus());
        client.stop();
    }

    public void HTTPBasicShort() throws Exception {
        Request request = new Request(Method.GET, this.uri);
        Client client = new Client(Protocol.HTTP);
        ChallengeResponse authentication = new ChallengeResponse(ChallengeScheme.HTTP_BASIC, SHORT_USERNAME, SHORT_PASSWORD);
        request.setChallengeResponse(authentication);
        Response response = client.handle(request);
        HttpBasicTestCase.assertEquals((String)"Short username did not return 200 OK", (Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HttpBasicTestCase.assertEquals((String)AUTHENTICATED_MSG, (String)response.getEntity().getText());
        client.stop();
    }

    public void HTTPBasicShortWrong() throws Exception {
        Request request = new Request(Method.GET, this.uri);
        Client client = new Client(Protocol.HTTP);
        ChallengeResponse authentication = new ChallengeResponse(ChallengeScheme.HTTP_BASIC, SHORT_USERNAME, LONG_PASSWORD);
        request.setChallengeResponse(authentication);
        Response response = client.handle(request);
        HttpBasicTestCase.assertEquals((String)"Short username did not throw 401", (Object)Status.CLIENT_ERROR_UNAUTHORIZED, (Object)response.getStatus());
        client.stop();
    }

    public void HTTPBasicWrongUser() throws Exception {
        Request request = new Request(Method.GET, this.uri);
        Client client = new Client(Protocol.HTTP);
        ChallengeResponse authentication = new ChallengeResponse(ChallengeScheme.HTTP_BASIC, WRONG_USERNAME, SHORT_PASSWORD);
        request.setChallengeResponse(authentication);
        Response response = client.handle(request);
        HttpBasicTestCase.assertEquals((String)"Wrong username did not throw 401", (Object)Status.CLIENT_ERROR_UNAUTHORIZED, (Object)response.getStatus());
        client.stop();
    }

    @Before
    public void makeServer() throws Exception {
        int port = TEST_PORT;
        this.component = new Component();
        this.component.getServers().add(Protocol.HTTP, port);
        this.uri = "http://localhost:" + port + "/";
        Application application = new Application(){

            public Restlet createInboundRoot() {
                HttpBasicTestCase.this.verifier = new TestVerifier();
                HttpBasicTestCase.this.authenticator = new ChallengeAuthenticator(this.getContext(), ChallengeScheme.HTTP_BASIC, HttpBasicTestCase.class.getSimpleName());
                HttpBasicTestCase.this.authenticator.setVerifier((Verifier)HttpBasicTestCase.this.verifier);
                HttpBasicTestCase.this.authenticator.setNext((Restlet)new AuthenticatedRestlet());
                return HttpBasicTestCase.this.authenticator;
            }
        };
        this.component.getDefaultHost().attach((Restlet)application);
        this.component.start();
    }

    @After
    public void stopServer() throws Exception {
        if (this.component != null && this.component.isStarted()) {
            this.component.stop();
        }
        this.component = null;
    }

    public void testHTTPBasic() {
        try {
            this.makeServer();
            this.HTTPBasicWrongUser();
            this.HTTPBasicShort();
            this.HTTPBasicShortWrong();
            this.HTTPBasicNone();
            this.HTTPBasicLong();
            this.HTTPBasicLongWrong();
            this.stopServer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class TestVerifier
    extends MapVerifier {
        public TestVerifier() {
            this.getLocalSecrets().put(HttpBasicTestCase.SHORT_USERNAME, HttpBasicTestCase.SHORT_PASSWORD.toCharArray());
            this.getLocalSecrets().put(HttpBasicTestCase.LONG_USERNAME, HttpBasicTestCase.LONG_PASSWORD.toCharArray());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean verify(String identifier, char[] inputSecret) {
            String almostSecret = new String(inputSecret);
            System.out.println("Checking " + identifier + " " + almostSecret);
            try {
                boolean bl = super.verify(identifier, inputSecret);
                return bl;
            }
            finally {
                Arrays.fill(inputSecret, '\u0000');
            }
        }
    }

    public class AuthenticatedRestlet
    extends Restlet {
        public void handle(Request request, Response response) {
            response.setEntity(HttpBasicTestCase.AUTHENTICATED_MSG, MediaType.TEXT_PLAIN);
        }
    }
}

