/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.engine.ConnectorHelper;
import org.restlet.engine.Engine;
import org.restlet.engine.connector.HttpClientHelper;
import org.restlet.ext.jetty.HttpServerHelper;
import org.restlet.test.RestletTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseConnectorsTestCase
extends RestletTestCase {
    private final boolean apacheClientEnabled = true;
    private Component component;
    private final boolean internalClientEnabled = true;
    private final boolean internalServerEnabled = true;
    private final boolean jdkNetClientEnabled = true;
    private final boolean jettyServerEnabled = true;
    private final boolean simpleServerEnabled = true;

    protected abstract void call(String var1) throws Exception;

    protected abstract Application createApplication(Component var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest(ConnectorHelper<Server> server, ConnectorHelper<Client> client) throws Exception {
        Engine nre = Engine.register((boolean)false);
        nre.getRegisteredServers().add(server);
        nre.getRegisteredClients().add(client);
        nre.registerDefaultAuthentications();
        nre.registerDefaultConverters();
        String uri = this.start();
        try {
            this.call(uri);
        }
        finally {
            this.stop();
        }
    }

    protected String start() throws Exception {
        this.component = new Component();
        Server server = this.component.getServers().add(Protocol.HTTP, 0);
        Application application = this.createApplication(this.component);
        this.component.getDefaultHost().attach((Restlet)application);
        this.component.start();
        return "http://localhost:" + server.getEphemeralPort() + "/test";
    }

    protected void stop() throws Exception {
        if (this.component != null && this.component.isStarted()) {
            this.component.stop();
        }
        this.component = null;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        Engine.register();
    }

    public void testInternalAndApache() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new org.restlet.engine.connector.HttpServerHelper(null), (ConnectorHelper<Client>)new org.restlet.ext.httpclient.HttpClientHelper(null));
    }

    public void testInternalAndInternal() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new org.restlet.engine.connector.HttpServerHelper(null), (ConnectorHelper<Client>)new HttpClientHelper(null));
    }

    public void testInternalAndJdkNet() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new org.restlet.engine.connector.HttpServerHelper(null), (ConnectorHelper<Client>)new org.restlet.ext.net.HttpClientHelper(null));
    }

    public void testJettyAndApache() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new HttpServerHelper(null), (ConnectorHelper<Client>)new org.restlet.ext.httpclient.HttpClientHelper(null));
    }

    public void testJettyAndInternal() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new HttpServerHelper(null), (ConnectorHelper<Client>)new HttpClientHelper(null));
    }

    public void testJettyAndJdkNet() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new HttpServerHelper(null), (ConnectorHelper<Client>)new org.restlet.ext.net.HttpClientHelper(null));
    }

    public void testSimpleAndApache() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new org.restlet.ext.simple.HttpServerHelper(null), (ConnectorHelper<Client>)new org.restlet.ext.httpclient.HttpClientHelper(null));
    }

    public void testSimpleAndInternal() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new org.restlet.ext.simple.HttpServerHelper(null), (ConnectorHelper<Client>)new HttpClientHelper(null));
    }

    public void testSimpleAndJdkNet() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new org.restlet.ext.simple.HttpServerHelper(null), (ConnectorHelper<Client>)new org.restlet.ext.net.HttpClientHelper(null));
    }
}

