/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.sip;

import junit.framework.TestCase;
import org.junit.Test;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.ext.sip.Address;
import org.restlet.ext.sip.internal.AddressReader;
import org.restlet.ext.sip.internal.AddressWriter;

public class AddressTestCase
extends TestCase {
    @Test
    public void testParsing() throws Exception {
        String str = "Anonymous <sip:c8oqz84zk7z@privacy.org>;tag=hyh8";
        AddressReader r = new AddressReader(str);
        Address a = r.readValue();
        AddressTestCase.assertEquals((String)"Anonymous", (String)a.getDisplayName());
        AddressTestCase.assertEquals((String)"sip:c8oqz84zk7z@privacy.org", (String)a.getReference().toString());
        AddressTestCase.assertEquals((int)1, (int)a.getParameters().size());
        Parameter parameter = (Parameter)a.getParameters().get(0);
        AddressTestCase.assertEquals((String)"tag", (String)parameter.getName());
        AddressTestCase.assertEquals((String)"hyh8", (String)parameter.getValue());
        str = "sip:+12125551212@server.phone2net.com;tag=887s";
        r = new AddressReader(str);
        a = r.readValue();
        AddressTestCase.assertNull((Object)a.getDisplayName());
        AddressTestCase.assertEquals((String)"sip:+12125551212@server.phone2net.com", (String)a.getReference().toString());
        AddressTestCase.assertEquals((int)1, (int)a.getParameters().size());
        parameter = (Parameter)a.getParameters().get(0);
        AddressTestCase.assertEquals((String)"tag", (String)parameter.getName());
        AddressTestCase.assertEquals((String)"887s", (String)parameter.getValue());
        str = "\"A. G. Bell\" <sip:agb@bell-telephone.com> ;tag=a48s";
        r = new AddressReader(str);
        a = r.readValue();
        AddressTestCase.assertEquals((String)"A. G. Bell", (String)a.getDisplayName());
        AddressTestCase.assertEquals((String)"sip:agb@bell-telephone.com", (String)a.getReference().toString());
        AddressTestCase.assertEquals((int)1, (int)a.getParameters().size());
        parameter = (Parameter)a.getParameters().get(0);
        AddressTestCase.assertEquals((String)"tag", (String)parameter.getName());
        AddressTestCase.assertEquals((String)"a48s", (String)parameter.getValue());
        str = "A. G. Bell <sip:agb@bell-telephone.com> ;tag=a48s";
        r = new AddressReader(str);
        a = r.readValue();
        r = new AddressReader(str);
        a = r.readValue();
        AddressTestCase.assertEquals((String)"A. G. Bell", (String)a.getDisplayName());
        AddressTestCase.assertEquals((String)"sip:agb@bell-telephone.com", (String)a.getReference().toString());
        AddressTestCase.assertEquals((int)1, (int)a.getParameters().size());
        parameter = (Parameter)a.getParameters().get(0);
        AddressTestCase.assertEquals((String)"tag", (String)parameter.getName());
        AddressTestCase.assertEquals((String)"a48s", (String)parameter.getValue());
    }

    @Test
    public void testWriting() {
        Address a = new Address();
        a.setDisplayName("A. G. Bell");
        a.setReference(new Reference("sip:agb@bell-telephone.com"));
        a.getParameters().add("tag", "a48s");
        AddressWriter w = new AddressWriter();
        AddressTestCase.assertEquals((String)"\"A. G. Bell\" <sip:agb@bell-telephone.com> ;tag=a48s", (String)w.append(a).toString());
        w = new AddressWriter();
        a = new Address();
        a.setDisplayName(null);
        a.setReference(new Reference("sip:agb@bell-telephone.com"));
        a.getParameters().add("tag", "a48s");
        AddressTestCase.assertEquals((String)"<sip:agb@bell-telephone.com> ;tag=a48s", (String)w.append(a).toString());
    }
}

