/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.tests;

import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.test.jaxrs.services.providers.BooleanEntityProvider;
import org.restlet.test.jaxrs.services.providers.CharacterEntityProvider;
import org.restlet.test.jaxrs.services.providers.IntegerEntityProvider;
import org.restlet.test.jaxrs.services.resources.PrimitiveWrapperEntityResource;
import org.restlet.test.jaxrs.services.tests.JaxRsTestCase;
import org.restlet.test.jaxrs.util.TestUtils;

public class PrimitiveWrapperEntityTest
extends JaxRsTestCase {
    protected Application getApplication() {
        Application appConfig = new Application(){

            public Set<Object> getSingletons() {
                return TestUtils.createSet(new IntegerEntityProvider(), new CharacterEntityProvider(), new BooleanEntityProvider());
            }

            public Set<Class<?>> getClasses() {
                return Collections.singleton(PrimitiveWrapperEntityResource.class);
            }
        };
        return appConfig;
    }

    public void test1() throws Exception {
        Response response = this.put("intReturnInt", (Representation)new StringRepresentation((CharSequence)"47"));
        PrimitiveWrapperEntityTest.sysOutEntityIfError(response);
        PrimitiveWrapperEntityTest.assertEquals((Object)Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE, (Object)response.getStatus());
    }

    public void test2() throws Exception {
        Response response = this.put("charReturnCharacter", (Representation)new StringRepresentation((CharSequence)"x"));
        PrimitiveWrapperEntityTest.sysOutEntityIfError(response);
        PrimitiveWrapperEntityTest.assertEquals((Object)Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE, (Object)response.getStatus());
    }

    public void test3() throws Exception {
        Response response = this.put("BooleanReturnboolean", (Representation)new StringRepresentation((CharSequence)"true"));
        PrimitiveWrapperEntityTest.sysOutEntityIfError(response);
        PrimitiveWrapperEntityTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PrimitiveWrapperEntityTest.assertEquals((String)"true", (String)response.getEntity().getText());
        response = this.put("BooleanReturnboolean", null);
        PrimitiveWrapperEntityTest.sysOutEntityIfError(response);
        PrimitiveWrapperEntityTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        if (response.getEntity() != null) {
            PrimitiveWrapperEntityTest.assertEquals((String)"false", (String)response.getEntity().getText());
        }
    }

    public void test4() throws Exception {
        Response response = this.put("integerReturnInteger", (Representation)new StringRepresentation((CharSequence)"47"));
        PrimitiveWrapperEntityTest.sysOutEntityIfError(response);
        PrimitiveWrapperEntityTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PrimitiveWrapperEntityTest.assertEquals((String)"47", (String)response.getEntity().getText());
        response = this.put("integerReturnInteger", null);
        PrimitiveWrapperEntityTest.sysOutEntityIfError(response);
        PrimitiveWrapperEntityTest.assertEquals((Object)Status.SUCCESS_NO_CONTENT, (Object)response.getStatus());
        PrimitiveWrapperEntityTest.assertEmptyEntity(response);
    }
}

