/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.connector;

import java.security.Principal;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.CacheDirective;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.Cookie;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Protocol;
import org.restlet.data.Range;
import org.restlet.data.Reference;
import org.restlet.data.Tag;
import org.restlet.data.Warning;
import org.restlet.engine.http.connector.ServerConnection;
import org.restlet.engine.http.header.CacheControlReader;
import org.restlet.engine.http.header.CookieReader;
import org.restlet.engine.http.header.HeaderReader;
import org.restlet.engine.http.header.HeaderUtils;
import org.restlet.engine.http.header.PreferenceUtils;
import org.restlet.engine.http.header.RangeUtils;
import org.restlet.engine.http.header.WarningReader;
import org.restlet.engine.security.AuthenticatorUtils;
import org.restlet.engine.util.DateUtils;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectedRequest
extends Request {
    private volatile boolean cacheDirectivesAdded;
    private volatile boolean clientAdded;
    private volatile boolean conditionAdded;
    private final Context context;
    private volatile boolean cookiesAdded;
    private volatile boolean proxySecurityAdded;
    private volatile boolean rangesAdded;
    private volatile boolean referrerAdded;
    private volatile boolean securityAdded;
    private volatile boolean warningsAdded;
    private final ServerConnection connection;
    private final Principal userPrincipal;

    public static void addHeader(Request request, String headerName, String headerValue) {
        if (request instanceof ConnectedRequest) {
            ((ConnectedRequest)request).getHeaders().add(headerName, headerValue);
        }
    }

    public ConnectedRequest(Context context, ServerConnection connection, String methodName, String resourceUri, String version, Series<Parameter> headers, Representation entity, boolean confidential, Principal userPrincipal) {
        String maxForwardsHeader;
        this.context = context;
        this.clientAdded = false;
        this.conditionAdded = false;
        this.connection = connection;
        this.cookiesAdded = false;
        this.referrerAdded = false;
        this.securityAdded = false;
        this.userPrincipal = userPrincipal;
        this.proxySecurityAdded = false;
        this.warningsAdded = false;
        this.setMethod(Method.valueOf(methodName));
        this.setEntity(entity);
        this.getAttributes().put("org.restlet.http.headers", headers);
        if (version != null) {
            int slashIndex = version.indexOf(47);
            version = slashIndex != -1 ? version.substring(slashIndex + 1) : null;
        }
        if (confidential) {
            Integer keySize;
            String cipherSuite;
            List<Certificate> clientCertificates = this.getConnection().getSslClientCertificates();
            if (clientCertificates != null) {
                this.getAttributes().put("org.restlet.https.clientCertificates", clientCertificates);
            }
            if ((cipherSuite = this.getConnection().getSslCipherSuite()) != null) {
                this.getAttributes().put("org.restlet.https.cipherSuite", cipherSuite);
            }
            if ((keySize = this.getConnection().getSslKeySize()) != null) {
                this.getAttributes().put("org.restlet.https.keySize", keySize);
            }
        }
        Protocol serverProtocol = ((Server)this.getConnection().getHelper().getHelped()).getProtocols().get(0);
        this.setProtocol(new Protocol(serverProtocol.getSchemeName(), serverProtocol.getName(), serverProtocol.getDescription(), serverProtocol.getDefaultPort(), serverProtocol.isConfidential(), version));
        String host = this.getHeaders() == null ? null : this.getHeaders().getFirstValue("Host", true);
        String hostDomain = null;
        int hostPort = -1;
        if (host != null) {
            int colonIndex = host.indexOf(58);
            if (colonIndex != -1) {
                hostDomain = host.substring(0, colonIndex);
                hostPort = Integer.valueOf(host.substring(colonIndex + 1));
            } else {
                hostDomain = host;
                hostPort = this.getProtocol().getDefaultPort();
            }
        } else if (!Protocol.SIP.getSchemeName().equals(serverProtocol.getSchemeName()) && !Protocol.SIPS.getSchemeName().equals(serverProtocol.getSchemeName())) {
            Context.getCurrentLogger().info("Couldn't find the mandatory \"Host\" HTTP header.");
        }
        Protocol protocol = ((Server)this.getConnection().getHelper().getHelped()).getProtocols().get(0);
        StringBuilder sb = new StringBuilder();
        sb.append(protocol.getSchemeName()).append("://");
        sb.append(hostDomain);
        if (hostPort != -1 && hostPort != protocol.getDefaultPort()) {
            sb.append(':').append(hostPort);
        }
        this.setHostRef(sb.toString());
        if (resourceUri != null) {
            this.setResourceRef(new Reference(this.getHostRef(), resourceUri));
            if (this.getResourceRef().isRelative()) {
                if (!resourceUri.startsWith("/")) {
                    this.setResourceRef(new Reference(this.getHostRef().toString() + "/" + resourceUri));
                } else {
                    this.setResourceRef(new Reference(this.getHostRef().toString() + resourceUri));
                }
            }
            this.setOriginalRef(this.getResourceRef().getTargetRef());
        }
        String dateHeader = this.getHeaders() == null ? null : this.getHeaders().getFirstValue("Date");
        Date date = null;
        if (dateHeader != null) {
            date = DateUtils.parse(dateHeader);
        }
        if (date == null) {
            date = new Date();
        }
        this.setDate(date);
        String string = maxForwardsHeader = this.getHeaders() == null ? null : this.getHeaders().getFirstValue("Max-Forwards");
        if (maxForwardsHeader != null) {
            try {
                this.setMaxForwards(Integer.parseInt(maxForwardsHeader));
            }
            catch (NumberFormatException nfe) {
                Context.getCurrentLogger().info("Unable to parse the Max-Forwards header: " + maxForwardsHeader);
            }
        }
    }

    @Override
    public void abort() {
        this.getConnection().close(false);
    }

    @Override
    public synchronized void commit(Response response) {
        if (response != null && !response.isCommitted()) {
            this.getConnection().commit(response);
            response.setCommitted(true);
        }
    }

    @Override
    public List<CacheDirective> getCacheDirectives() {
        List<CacheDirective> result = super.getCacheDirectives();
        if (!this.cacheDirectivesAdded) {
            if (this.getHeaders() != null) {
                for (String string : this.getHeaders().getValuesArray("Cache-Control")) {
                    CacheControlReader ccr = new CacheControlReader(string);
                    try {
                        result.addAll(ccr.readDirectives());
                    }
                    catch (Exception e) {
                        Context.getCurrentLogger().log(Level.WARNING, "Error during cache control parsing. Header: " + string, e);
                    }
                }
                this.setCacheDirectives(result);
            }
            this.cacheDirectivesAdded = true;
        }
        return result;
    }

    @Override
    public ChallengeResponse getChallengeResponse() {
        ChallengeResponse result = super.getChallengeResponse();
        if (!this.securityAdded) {
            if (this.getHeaders() != null) {
                String authorization = this.getHeaders().getValues("Authorization");
                result = AuthenticatorUtils.parseResponse(this, authorization, this.getHeaders());
                this.setChallengeResponse(result);
            }
            this.securityAdded = true;
        }
        return result;
    }

    @Override
    public ClientInfo getClientInfo() {
        ClientInfo result = super.getClientInfo();
        if (!this.clientAdded) {
            if (this.getHeaders() != null) {
                String header;
                boolean useForwardedForHeader;
                String acceptCharset = this.getHeaders().getValues("Accept-Charset");
                String acceptEncoding = this.getHeaders().getValues("Accept-Encoding");
                String acceptLanguage = this.getHeaders().getValues("Accept-Language");
                String acceptMediaType = this.getHeaders().getValues("Accept");
                try {
                    PreferenceUtils.parseCharacterSets(acceptCharset, result);
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, e.getMessage());
                }
                try {
                    PreferenceUtils.parseEncodings(acceptEncoding, result);
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, e.getMessage());
                }
                try {
                    PreferenceUtils.parseLanguages(acceptLanguage, result);
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, e.getMessage());
                }
                try {
                    PreferenceUtils.parseMediaTypes(acceptMediaType, result);
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, e.getMessage());
                }
                result.setAgent(this.getHeaders().getValues("User-Agent"));
                result.setFrom(this.getHeaders().getValues("From"));
                result.setAddress(this.getConnection().getAddress());
                result.setPort(this.getConnection().getPort());
                if (this.userPrincipal != null) {
                    result.getPrincipals().add(this.userPrincipal);
                }
                if (this.context != null && (useForwardedForHeader = Boolean.parseBoolean(this.context.getParameters().getFirstValue("useForwardedForHeader", false))) && (header = this.getHeaders().getValues("X-Forwarded-For")) != null) {
                    String[] addresses = header.split(",");
                    for (int i = 0; i < addresses.length; ++i) {
                        String address = addresses[i].trim();
                        result.getForwardedAddresses().add(address);
                    }
                }
            }
            this.clientAdded = true;
        }
        return result;
    }

    @Override
    public Conditions getConditions() {
        Conditions result = super.getConditions();
        if (!this.conditionAdded) {
            if (this.getHeaders() != null) {
                String ifMatchHeader = this.getHeaders().getValues("If-Match");
                String ifNoneMatchHeader = this.getHeaders().getValues("If-None-Match");
                Date ifModifiedSince = null;
                Date ifUnmodifiedSince = null;
                String ifRangeHeader = this.getHeaders().getFirstValue("If-Range");
                for (Parameter header : this.getHeaders()) {
                    if (header.getName().equalsIgnoreCase("If-Modified-Since")) {
                        ifModifiedSince = HeaderUtils.parseDate(header.getValue(), false);
                        continue;
                    }
                    if (!header.getName().equalsIgnoreCase("If-Unmodified-Since")) continue;
                    ifUnmodifiedSince = HeaderUtils.parseDate(header.getValue(), false);
                }
                if (ifModifiedSince != null && ifModifiedSince.getTime() != -1L) {
                    result.setModifiedSince(ifModifiedSince);
                }
                if (ifUnmodifiedSince != null && ifUnmodifiedSince.getTime() != -1L) {
                    result.setUnmodifiedSince(ifUnmodifiedSince);
                }
                ArrayList<Tag> match = null;
                Tag current = null;
                if (ifMatchHeader != null) {
                    try {
                        HeaderReader hr = new HeaderReader(ifMatchHeader);
                        String value = hr.readValue();
                        while (value != null) {
                            current = Tag.parse(value);
                            if (match == null) {
                                match = new ArrayList<Tag>();
                                result.setMatch(match);
                            }
                            match.add(current);
                            value = hr.readValue();
                        }
                    }
                    catch (Exception e) {
                        this.context.getLogger().log(Level.INFO, "Unable to process the if-match header: " + ifMatchHeader);
                    }
                }
                ArrayList<Tag> noneMatch = null;
                if (ifNoneMatchHeader != null) {
                    try {
                        HeaderReader hr = new HeaderReader(ifNoneMatchHeader);
                        String value = hr.readValue();
                        while (value != null) {
                            current = Tag.parse(value);
                            if (noneMatch == null) {
                                noneMatch = new ArrayList<Tag>();
                                result.setNoneMatch(noneMatch);
                            }
                            noneMatch.add(current);
                            value = hr.readValue();
                        }
                    }
                    catch (Exception e) {
                        this.context.getLogger().log(Level.INFO, "Unable to process the if-none-match header: " + ifNoneMatchHeader);
                    }
                }
                if (ifRangeHeader != null && ifRangeHeader.length() > 0) {
                    Tag tag = Tag.parse(ifRangeHeader);
                    if (tag != null) {
                        result.setRangeTag(tag);
                    } else {
                        Date date = HeaderUtils.parseDate(ifRangeHeader, false);
                        result.setRangeDate(date);
                    }
                }
            }
            this.conditionAdded = true;
        }
        return result;
    }

    protected ServerConnection getConnection() {
        return this.connection;
    }

    @Override
    public Series<Cookie> getCookies() {
        Series<Cookie> result = super.getCookies();
        if (!this.cookiesAdded) {
            String cookiesValue;
            if (this.getHeaders() != null && (cookiesValue = this.getHeaders().getValues("Cookie")) != null) {
                try {
                    CookieReader cr = new CookieReader(cookiesValue);
                    Cookie current = cr.readCookie();
                    while (current != null) {
                        result.add(current);
                        current = cr.readCookie();
                    }
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.WARNING, "An exception occurred during cookies parsing. Headers value: " + cookiesValue, e);
                }
            }
            this.cookiesAdded = true;
        }
        return result;
    }

    public Series<Parameter> getHeaders() {
        return (Series)this.getAttributes().get("org.restlet.http.headers");
    }

    @Override
    public ChallengeResponse getProxyChallengeResponse() {
        ChallengeResponse result = super.getProxyChallengeResponse();
        if (!this.proxySecurityAdded) {
            if (this.getHeaders() != null) {
                String authorization = this.getHeaders().getValues("Proxy-Authorization");
                result = AuthenticatorUtils.parseResponse(this, authorization, this.getHeaders());
                this.setProxyChallengeResponse(result);
            }
            this.proxySecurityAdded = true;
        }
        return result;
    }

    @Override
    public List<Range> getRanges() {
        List<Range> result = super.getRanges();
        if (!this.rangesAdded) {
            if (this.getHeaders() != null) {
                String ranges = this.getHeaders().getValues("Range");
                result.addAll(RangeUtils.parseRangeHeader(ranges));
            }
            this.rangesAdded = true;
        }
        return result;
    }

    @Override
    public Reference getReferrerRef() {
        if (!this.referrerAdded) {
            String referrerValue;
            if (this.getHeaders() != null && (referrerValue = this.getHeaders().getValues("Referer")) != null) {
                this.setReferrerRef(new Reference(referrerValue));
            }
            this.referrerAdded = true;
        }
        return super.getReferrerRef();
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    @Override
    public List<Warning> getWarnings() {
        List<Warning> result = super.getWarnings();
        if (!this.warningsAdded) {
            if (this.getHeaders() != null) {
                for (String string : this.getHeaders().getValuesArray("Warning")) {
                    WarningReader hr = new WarningReader(string);
                    try {
                        result.add(hr.readWarning());
                    }
                    catch (Exception e) {
                        Context.getCurrentLogger().log(Level.WARNING, "Error during warning parsing. Header: " + string, e);
                    }
                }
                this.setWarnings(result);
            }
            this.warningsAdded = true;
        }
        return result;
    }

    @Override
    public void setChallengeResponse(ChallengeResponse response) {
        super.setChallengeResponse(response);
        this.securityAdded = true;
    }

    @Override
    public void setProxyChallengeResponse(ChallengeResponse response) {
        super.setProxyChallengeResponse(response);
        this.proxySecurityAdded = true;
    }

    @Override
    public void setWarnings(List<Warning> warnings) {
        super.setWarnings(warnings);
        this.warningsAdded = true;
    }
}

