/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.security;

import java.io.IOException;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.data.Status;
import org.restlet.engine.Helper;
import org.restlet.engine.http.header.HeaderBuilder;
import org.restlet.security.Guard;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthenticatorHelper
extends Helper {
    private volatile ChallengeScheme challengeScheme;
    private volatile boolean clientSide;
    private volatile boolean serverSide;

    public AuthenticatorHelper(ChallengeScheme challengeScheme, boolean clientSide, boolean serverSide) {
        this.challengeScheme = challengeScheme;
        this.clientSide = clientSide;
        this.serverSide = serverSide;
    }

    @Deprecated
    public int authenticate(ChallengeResponse cr, Request request, Guard guard) {
        int result = 0;
        String identifier = cr.getIdentifier();
        char[] secret = cr.getSecret();
        if (identifier != null && secret != null) {
            result = guard.checkSecret(request, identifier, secret) ? 1 : -1;
        }
        return result;
    }

    @Deprecated
    public void challenge(Response response, boolean stale, Guard guard) {
        response.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
        response.getChallengeRequests().add(new ChallengeRequest(guard.getScheme(), guard.getRealm()));
    }

    public void formatRawRequest(HeaderBuilder hb, ChallengeRequest challenge, Response response, Series<Parameter> httpHeaders) throws IOException {
    }

    public void formatRawResponse(HeaderBuilder hb, ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) throws IOException {
    }

    public String formatRequest(ChallengeRequest challenge, Response response, Series<Parameter> httpHeaders) throws IOException {
        HeaderBuilder hb = new HeaderBuilder();
        hb.append(challenge.getScheme().getTechnicalName()).appendSpace();
        if (challenge.getRawValue() != null) {
            hb.append(challenge.getRawValue());
        } else {
            this.formatRawRequest(hb, challenge, response, httpHeaders);
        }
        return hb.toString();
    }

    public String formatResponse(ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) throws IOException {
        HeaderBuilder hb = new HeaderBuilder();
        hb.append(challenge.getScheme().getTechnicalName()).appendSpace();
        if (challenge.getRawValue() != null) {
            hb.append(challenge.getRawValue());
        } else {
            this.formatRawResponse(hb, challenge, request, httpHeaders);
        }
        return hb.toString();
    }

    public char[] formatSecret(ChallengeResponse challengeResponse, Request previousRequest, Response previousResponse, String identifier, char[] baseSecret, String baseSecretAlgorithm) {
        if (baseSecret != null) {
            return baseSecret;
        }
        return null;
    }

    public ChallengeScheme getChallengeScheme() {
        return this.challengeScheme;
    }

    public Logger getLogger() {
        return Context.getCurrentLogger();
    }

    public boolean isClientSide() {
        return this.clientSide;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public void parseRequest(ChallengeRequest challenge, Response response, Series<Parameter> httpHeaders) {
    }

    public void parseResponse(ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
    }

    public void setChallengeScheme(ChallengeScheme challengeScheme) {
        this.challengeScheme = challengeScheme;
    }

    public void setClientSide(boolean clientSide) {
        this.clientSide = clientSide;
    }

    public void setServerSide(boolean serverSide) {
        this.serverSide = serverSide;
    }
}

