/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.connector;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import org.restlet.Server;
import org.restlet.engine.http.connector.BaseServerHelper;
import org.restlet.engine.http.connector.BaseTask;
import org.restlet.engine.http.connector.Connection;

public class AcceptorTask
extends BaseTask {
    private final BaseServerHelper helper;
    private final ServerSocket serverSocket;
    private final CountDownLatch latch;

    public AcceptorTask(BaseServerHelper helper, ServerSocket serverSocket, CountDownLatch latch) {
        this.helper = helper;
        this.serverSocket = serverSocket;
        this.latch = latch;
    }

    protected BaseServerHelper getHelper() {
        return this.helper;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void run() {
        this.latch.countDown();
        this.setRunning(true);
        while (this.isRunning()) {
            try {
                Socket socket = this.serverSocket.accept();
                int connectionsCount = this.getHelper().getConnections().size();
                if (this.getHelper().getMaxTotalConnections() == -1 || connectionsCount <= this.getHelper().getMaxTotalConnections()) {
                    Connection<Server> connection = this.getHelper().createConnection(this.getHelper(), socket, null);
                    connection.open();
                    this.getHelper().getConnections().add(connection);
                    continue;
                }
                socket.close();
                this.getHelper().getLogger().info("Maximum number of concurrent connections reached. New connection rejected.");
            }
            catch (ClosedByInterruptException ex) {
                this.helper.getLogger().log(Level.FINE, "ServerSocket channel was closed by interrupt", ex);
                break;
            }
            catch (AsynchronousCloseException ace) {
                this.helper.getLogger().log(Level.FINE, "The server socket was closed", ace);
            }
            catch (SocketException se) {
                this.helper.getLogger().log(Level.FINE, "The server socket was closed", se);
            }
            catch (IOException ex) {
                this.helper.getLogger().log(Level.WARNING, "Unexpected error while accepting new connection", ex);
            }
        }
    }
}

