/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.header;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.Parameter;
import org.restlet.engine.http.header.HeaderUtils;
import org.restlet.engine.util.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderReader<V> {
    private final String header;
    private volatile int index;

    public static Date readDate(String date, boolean cookie) {
        if (cookie) {
            return DateUtils.parse(date, DateUtils.FORMAT_RFC_1036);
        }
        return DateUtils.parse(date, DateUtils.FORMAT_RFC_1123);
    }

    public static Parameter readHeader(InputStream is, StringBuilder sb) throws IOException {
        Parameter result = null;
        int next = is.read();
        if (HeaderUtils.isCarriageReturn(next)) {
            next = is.read();
            if (!HeaderUtils.isLineFeed(next)) {
                throw new IOException("Invalid end of headers. Line feed missing after the carriage return.");
            }
        } else {
            result = new Parameter();
            while (next != -1 && next != 58) {
                sb.append((char)next);
                next = is.read();
            }
            if (next == -1) {
                throw new IOException("Unable to parse the header name. End of stream reached too early.");
            }
            result.setName(sb.toString());
            sb.delete(0, sb.length());
            next = is.read();
            while (HeaderUtils.isSpace(next)) {
                next = is.read();
            }
            while (next != -1 && !HeaderUtils.isCarriageReturn(next)) {
                sb.append((char)next);
                next = is.read();
            }
            if (next == -1) {
                throw new IOException("Unable to parse the header value. End of stream reached too early.");
            }
            next = is.read();
            if (HeaderUtils.isLineFeed(next)) {
                result.setValue(sb.toString());
                sb.delete(0, sb.length());
            } else {
                throw new IOException("Unable to parse the HTTP header value. The carriage return must be followed by a line feed.");
            }
        }
        return result;
    }

    public HeaderReader(String header) {
        this.header = header;
        this.index = header == null || header.length() == 0 ? -1 : 0;
    }

    public void addValues(Collection<V> values) {
        try {
            this.skipSpaces();
            V nextValue = this.readValue();
            while (this.canAdd(nextValue, values)) {
                values.add(nextValue);
                if (!this.skipValueSeparator()) continue;
                nextValue = this.readValue();
            }
        }
        catch (IOException ioe) {
            Context.getCurrentLogger().log(Level.INFO, "Unable to read a header", ioe);
        }
    }

    protected boolean canAdd(V value, Collection<V> values) {
        return value != null && !values.contains(value);
    }

    protected final Parameter createParameter(String name) {
        return this.createParameter(name, null);
    }

    protected Parameter createParameter(String name, String value) {
        return new Parameter(name, value);
    }

    public int peek() {
        int result = -1;
        if (this.index != -1) {
            result = this.header.charAt(this.index);
        }
        return result;
    }

    public int read() {
        int result = -1;
        if (this.index >= 0) {
            result = this.header.charAt(this.index++);
            if (this.index >= this.header.length()) {
                this.index = -1;
            }
        }
        return result;
    }

    public String readDigits() {
        StringBuilder sb = new StringBuilder();
        int next = this.read();
        while (HeaderUtils.isTokenChar(next)) {
            sb.append((char)next);
            next = this.read();
        }
        this.unread();
        return sb.toString();
    }

    public Parameter readParameter() throws IOException {
        Parameter result = null;
        String name = this.readToken();
        int nextChar = this.read();
        if (name.length() > 0) {
            if (nextChar == 61) {
                result = this.createParameter(name, this.readParameterValue());
            } else {
                this.unread();
                result = this.createParameter(name);
            }
        } else {
            throw new IOException("Parameter or extension has no name. Please check your value");
        }
        return result;
    }

    public String readParameterValue() throws IOException {
        String result = null;
        this.skipSpaces();
        int nextChar = this.peek();
        if (HeaderUtils.isDoubleQuote(nextChar)) {
            result = this.readQuotedString();
        } else if (HeaderUtils.isTokenChar(nextChar)) {
            result = this.readToken();
        }
        return result;
    }

    public String readComment() throws IOException {
        String result = null;
        int next = this.read();
        if (next == 40) {
            StringBuilder buffer = new StringBuilder();
            while (result == null) {
                next = this.read();
                if (HeaderUtils.isCommentText(next)) {
                    buffer.append((char)next);
                    continue;
                }
                if (HeaderUtils.isQuoteCharacter(next)) {
                    buffer.append((char)this.read());
                    continue;
                }
                if (next == 40) {
                    buffer.append('(').append(this.readComment()).append(')');
                    continue;
                }
                if (next == 41) {
                    result = buffer.toString();
                    continue;
                }
                if (next == -1) {
                    throw new IOException("Unexpected end of comment. Please check your value");
                }
                throw new IOException("Invalid character \"" + next + "\" detected in comment. Please check your value");
            }
        } else {
            throw new IOException("A comment must start with a parenthesis");
        }
        return result;
    }

    public String readQuotedString() throws IOException {
        String result = null;
        int next = this.read();
        if (HeaderUtils.isDoubleQuote(next)) {
            StringBuilder buffer = new StringBuilder();
            while (result == null) {
                next = this.read();
                if (HeaderUtils.isQuotedText(next)) {
                    buffer.append((char)next);
                    continue;
                }
                if (HeaderUtils.isQuoteCharacter(next)) {
                    buffer.append((char)this.read());
                    continue;
                }
                if (HeaderUtils.isDoubleQuote(next)) {
                    result = buffer.toString();
                    continue;
                }
                if (next == -1) {
                    throw new IOException("Unexpected end of quoted string. Please check your value");
                }
                throw new IOException("Invalid character \"" + next + "\" detected in quoted string. Please check your value");
            }
        } else {
            throw new IOException("A quoted string must start with a double quote");
        }
        return result;
    }

    public String readRawText() {
        StringBuilder sb = null;
        int next = this.read();
        while (next != -1 && !HeaderUtils.isSpace(next) && !HeaderUtils.isComma(next)) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append((char)next);
            next = this.read();
        }
        if (HeaderUtils.isSpace(next) || HeaderUtils.isComma(next)) {
            this.unread();
        }
        return sb == null ? null : sb.toString();
    }

    public String readRawValue() {
        this.skipSpaces();
        StringBuilder sb = null;
        int next = this.read();
        while (next != -1 && !HeaderUtils.isComma(next)) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append((char)next);
            next = this.read();
        }
        if (sb != null) {
            for (int i = sb.length() - 1; i >= 0 && HeaderUtils.isLinearWhiteSpace(sb.charAt(i)); --i) {
                sb.deleteCharAt(i);
            }
        }
        if (HeaderUtils.isComma(next)) {
            this.unread();
        }
        return sb == null ? null : sb.toString();
    }

    public String readToken() {
        StringBuilder sb = new StringBuilder();
        int next = this.read();
        while (HeaderUtils.isTokenChar(next)) {
            sb.append((char)next);
            next = this.read();
        }
        this.unread();
        return sb.toString();
    }

    public V readValue() throws IOException {
        return null;
    }

    public List<V> readValues() {
        CopyOnWriteArrayList result = new CopyOnWriteArrayList();
        this.addValues(result);
        return result;
    }

    public boolean skipParameterSeparator() {
        boolean result = false;
        this.skipSpaces();
        if (HeaderUtils.isSemiColon(this.read())) {
            result = true;
            this.skipSpaces();
        } else {
            this.unread();
        }
        return result;
    }

    public boolean skipSpaces() {
        boolean result = false;
        int next = this.peek();
        while (HeaderUtils.isLinearWhiteSpace(next) && next != -1) {
            result = result || HeaderUtils.isLinearWhiteSpace(next);
            this.read();
            next = this.peek();
        }
        return result;
    }

    public boolean skipValueSeparator() {
        boolean result = false;
        this.skipSpaces();
        if (HeaderUtils.isComma(this.read())) {
            result = true;
            this.skipSpaces();
        } else {
            this.unread();
        }
        return result;
    }

    public void unread() {
        if (this.index > 0) {
            --this.index;
        }
    }
}

