/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.header;

import java.io.IOException;
import java.util.Collection;
import org.restlet.data.Parameter;
import org.restlet.data.Status;
import org.restlet.data.Warning;
import org.restlet.engine.http.header.HeaderReader;
import org.restlet.engine.util.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarningReader
extends HeaderReader<Warning> {
    public static void addValues(Parameter header, Collection<Warning> collection) {
        new WarningReader(header.getValue()).addValues(collection);
    }

    public WarningReader(String header) {
        super(header);
    }

    @Override
    public Warning readValue() throws IOException {
        Warning result = new Warning();
        String code = this.readToken();
        String agent = this.readRawValue();
        String text = this.readQuotedString();
        String date = this.readQuotedString();
        if (code == null || agent == null || text == null) {
            throw new IOException("Warning header malformed.");
        }
        result.setStatus(Status.valueOf(Integer.parseInt(code)));
        result.setAgent(agent);
        result.setText(text);
        result.setDate(DateUtils.parse(date));
        return result;
    }
}

