/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.header;

import java.util.Collection;
import org.restlet.data.Dimension;
import org.restlet.engine.http.header.HeaderWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionWriter
extends HeaderWriter<Dimension> {
    public static String write(Collection<Dimension> dimensions) {
        return new DimensionWriter().append((Collection)dimensions).toString();
    }

    public DimensionWriter append(Collection<Dimension> dimensions) {
        if (dimensions != null && !dimensions.isEmpty()) {
            if (dimensions.contains((Object)Dimension.CLIENT_ADDRESS) || dimensions.contains((Object)Dimension.TIME) || dimensions.contains((Object)Dimension.UNSPECIFIED)) {
                this.append("*");
            } else {
                boolean first = true;
                for (Dimension dimension : dimensions) {
                    if (first) {
                        first = false;
                    } else {
                        this.append(", ");
                    }
                    this.append(dimension);
                }
            }
        }
        return this;
    }

    @Override
    public HeaderWriter<Dimension> append(Dimension dimension) {
        if (dimension == Dimension.CHARACTER_SET) {
            this.append("Accept-Charset");
        } else if (dimension == Dimension.CLIENT_AGENT) {
            this.append("User-Agent");
        } else if (dimension == Dimension.ENCODING) {
            this.append("Accept-Encoding");
        } else if (dimension == Dimension.LANGUAGE) {
            this.append("Accept-Language");
        } else if (dimension == Dimension.MEDIA_TYPE) {
            this.append("Accept");
        } else if (dimension == Dimension.AUTHORIZATION) {
            this.append("Authorization");
        }
        return this;
    }
}

