/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.Engine;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterUtils {
    protected static List<VariantInfo> addVariant(List<VariantInfo> variants, VariantInfo variant) {
        List<VariantInfo> result = variants;
        if (result == null) {
            result = new ArrayList<VariantInfo>();
        }
        if (!result.contains(variant)) {
            result.add(variant);
        }
        return result;
    }

    public static List<VariantInfo> getVariants(Class<?> sourceClass, Variant targetVariant) {
        List<VariantInfo> result = null;
        List<VariantInfo> helperVariants = null;
        for (ConverterHelper ch : Engine.getInstance().getRegisteredConverters()) {
            helperVariants = ch.getVariants(sourceClass);
            if (helperVariants == null) continue;
            for (VariantInfo helperVariant : helperVariants) {
                if (targetVariant == null) {
                    result = ConverterUtils.addVariant(result, helperVariant);
                    continue;
                }
                if (helperVariant.includes(targetVariant)) {
                    result = ConverterUtils.addVariant(result, new VariantInfo(targetVariant.getMediaType()));
                    continue;
                }
                if (!targetVariant.includes(helperVariant)) continue;
                result = ConverterUtils.addVariant(result, helperVariant);
            }
        }
        return result;
    }

    public static ConverterHelper getBestHelper(Object source, Variant target, Resource resource) {
        ConverterHelper result = null;
        float bestScore = -1.0f;
        for (ConverterHelper ch : Engine.getInstance().getRegisteredConverters()) {
            try {
                float currentScore = ch.score(source, target, resource);
                if (!(currentScore > bestScore)) continue;
                bestScore = currentScore;
                result = ch;
            }
            catch (Exception e) {
                Context.getCurrentLogger().log(Level.SEVERE, "Unable get the score of the " + ch + " converter helper.", e);
            }
        }
        return result;
    }

    public static <T> ConverterHelper getBestHelper(Representation source, Class<T> target, Resource resource) {
        ConverterHelper result = null;
        float bestScore = -1.0f;
        for (ConverterHelper ch : Engine.getInstance().getRegisteredConverters()) {
            float currentScore = ch.score(source, target, resource);
            if (!(currentScore > bestScore)) continue;
            bestScore = currentScore;
            result = ch;
        }
        return result;
    }

    private ConverterUtils() {
    }
}

