/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.resource;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.service.ConverterService;
import org.restlet.service.MetadataService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationInfo {
    private final String input;
    private final java.lang.reflect.Method javaMethod;
    private final String output;
    private final String query;
    private final Class<?> resourceClass;
    private final Method restletMethod;

    private static Class<?> getJavaActualType(Class<?> currentClass, String genericTypeName) {
        Class<?> result = null;
        result = AnnotationInfo.getJavaActualType(currentClass.getGenericSuperclass(), genericTypeName);
        if (result == null) {
            Type[] interfaceTypes = currentClass.getGenericInterfaces();
            for (int i = 0; result == null && i < interfaceTypes.length; ++i) {
                result = AnnotationInfo.getJavaActualType(interfaceTypes[i], genericTypeName);
            }
        }
        return result;
    }

    private static Class<?> getJavaActualType(Type currentType, String genericTypeName) {
        Class<?> result = null;
        if (currentType != null) {
            if (currentType instanceof Class) {
                result = AnnotationInfo.getJavaActualType((Class)currentType, genericTypeName);
            } else if (currentType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)currentType;
                Class rawType = (Class)parameterizedType.getRawType();
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
                for (int i = 0; result == null && i < actualTypeArguments.length; ++i) {
                    if (!genericTypeName.equals(typeParameters[i].getName())) continue;
                    result = AnnotationInfo.getTypeClass(actualTypeArguments[i]);
                }
            }
        }
        return result;
    }

    private static Class<?> getTypeClass(Type type) {
        Type componentType;
        Class<?> componentClass;
        Class<?> result = null;
        if (type instanceof Class) {
            result = (Class<?>)type;
        } else if (type instanceof ParameterizedType) {
            result = AnnotationInfo.getTypeClass(((ParameterizedType)type).getRawType());
        } else if (type instanceof GenericArrayType && (componentClass = AnnotationInfo.getTypeClass(componentType = ((GenericArrayType)type).getGenericComponentType())) != null) {
            result = Array.newInstance(componentClass, 0).getClass();
        }
        return result;
    }

    public AnnotationInfo(Class<?> resourceClass, Method restletMethod, java.lang.reflect.Method javaMethod, String value) {
        this.resourceClass = resourceClass;
        this.restletMethod = restletMethod;
        this.javaMethod = javaMethod;
        if (value != null && !value.equals("")) {
            int queryIndex = value.indexOf(63);
            if (queryIndex != -1) {
                this.query = value.substring(queryIndex + 1);
                value = value.substring(0, queryIndex);
            } else {
                this.query = null;
            }
            int ioSeparatorIndex = value.indexOf(58);
            if (ioSeparatorIndex != -1) {
                this.input = value.substring(0, ioSeparatorIndex);
                this.output = value.substring(ioSeparatorIndex + 1);
            } else {
                this.input = value;
                this.output = value;
            }
        } else {
            this.query = null;
            this.input = null;
            this.output = null;
        }
    }

    public boolean equals(Object other) {
        boolean result = other instanceof AnnotationInfo;
        if (result && other != this) {
            AnnotationInfo otherAnnotation = (AnnotationInfo)other;
            if (result) {
                boolean bl = result = this.getJavaMethod() == null && otherAnnotation.getJavaMethod() == null || this.getJavaMethod() != null && this.getJavaMethod().equals(otherAnnotation.getJavaMethod());
            }
            if (result) {
                boolean bl = result = this.getResourceClass() == null && otherAnnotation.getResourceClass() == null || this.getResourceClass() != null && this.getResourceClass().equals(otherAnnotation.getResourceClass());
            }
            if (result) {
                boolean bl = result = this.getRestletMethod() == null && otherAnnotation.getRestletMethod() == null || this.getRestletMethod() != null && this.getRestletMethod().equals(otherAnnotation.getRestletMethod());
            }
            if (result) {
                boolean bl = result = this.getInput() == null && otherAnnotation.getInput() == null || this.getInput() != null && this.getInput().equals(otherAnnotation.getInput());
            }
            if (result) {
                boolean bl = result = this.getOutput() == null && otherAnnotation.getOutput() == null || this.getOutput() != null && this.getOutput().equals(otherAnnotation.getOutput());
            }
            if (result) {
                result = this.getQuery() == null && otherAnnotation.getQuery() == null || this.getQuery() != null && this.getQuery().equals(otherAnnotation.getQuery());
            }
        }
        return result;
    }

    public String getInput() {
        return this.input;
    }

    private Class<?> getJavaActualType(Class<?> initialType, Type genericType) {
        Class<?> result = initialType;
        try {
            if (genericType instanceof TypeVariable) {
                TypeVariable genericTypeVariable = (TypeVariable)genericType;
                String genericTypeName = genericTypeVariable.getName();
                result = AnnotationInfo.getJavaActualType(this.getResourceClass(), genericTypeName);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return result;
    }

    public Class<?> getJavaInputType(int index) {
        return this.getJavaActualType(this.getJavaMethod().getParameterTypes()[index], this.getJavaMethod().getGenericParameterTypes()[index]);
    }

    public Class<?>[] getJavaInputTypes() {
        int count = this.getJavaMethod().getParameterTypes().length;
        Class[] classes = new Class[count];
        for (int i = 0; i < count; ++i) {
            classes[i] = this.getJavaInputType(i);
        }
        return classes;
    }

    public java.lang.reflect.Method getJavaMethod() {
        return this.javaMethod;
    }

    public Class<?> getJavaOutputType() {
        return this.getJavaActualType(this.getJavaMethod().getReturnType(), this.getJavaMethod().getGenericReturnType());
    }

    public String getOutput() {
        return this.output;
    }

    public String getQuery() {
        return this.query;
    }

    public List<Variant> getRequestVariants(MetadataService metadataService, ConverterService converterService) {
        List<Variant> result = null;
        Class<?>[] classes = this.getJavaInputTypes();
        if (classes != null && classes.length >= 1 && (result = this.getVariants(metadataService, this.getInput())) == null) {
            Class<?> inputClass = classes[0];
            result = converterService.getVariants(inputClass, null);
        }
        return result;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public List<Variant> getResponseVariants(MetadataService metadataService, ConverterService converterService) {
        List<Variant> result = null;
        if (this.getJavaOutputType() != null && this.getJavaOutputType() != Void.TYPE && this.getJavaOutputType() != Void.class && (result = this.getVariants(metadataService, this.getOutput())) == null) {
            result = converterService.getVariants(this.getJavaOutputType(), null);
        }
        return result;
    }

    public Method getRestletMethod() {
        return this.restletMethod;
    }

    private List<Variant> getVariants(MetadataService metadataService, String annotationValue) {
        ArrayList<Variant> result = null;
        if (annotationValue != null) {
            String[] variants;
            for (String variantValue : variants = annotationValue.split("\\|")) {
                Variant variant = null;
                String[] extensions = variantValue.split("\\+");
                ArrayList<MediaType> mediaTypes = null;
                ArrayList<Language> languages = null;
                CharacterSet characterSet = null;
                for (String extension : extensions) {
                    List<Metadata> metadataList;
                    if (extension == null || (metadataList = metadataService.getAllMetadata(extension)) == null) continue;
                    for (Metadata metadata : metadataList) {
                        if (metadata instanceof MediaType) {
                            if (mediaTypes == null) {
                                mediaTypes = new ArrayList<MediaType>();
                            }
                            mediaTypes.add((MediaType)metadata);
                            continue;
                        }
                        if (metadata instanceof Language) {
                            if (languages == null) {
                                languages = new ArrayList<Language>();
                            }
                            languages.add((Language)metadata);
                            continue;
                        }
                        if (!(metadata instanceof CharacterSet)) continue;
                        if (characterSet == null) {
                            characterSet = (CharacterSet)metadata;
                            continue;
                        }
                        Context.getCurrentLogger().warning("A representation variant can have only one character set. Please check your annotation value.");
                    }
                }
                if (mediaTypes == null) continue;
                for (MediaType mediaType : mediaTypes) {
                    if (result != null && result.contains(mediaType)) continue;
                    if (result == null) {
                        result = new ArrayList<Variant>();
                    }
                    variant = new Variant(mediaType);
                    if (languages != null) {
                        variant.getLanguages().addAll(languages);
                    }
                    if (characterSet != null) {
                        variant.setCharacterSet(characterSet);
                    }
                    result.add(variant);
                }
            }
        }
        return result;
    }

    public boolean isCompatible(Method restletMethod, Form queryParams, Representation requestEntity, MetadataService metadataService, ConverterService converterService) {
        boolean result = true;
        if (this.getQuery() != null) {
            Form requiredParams = new Form(this.getQuery());
            Iterator iter = requiredParams.iterator();
            while (iter.hasNext() && result) {
                result = queryParams.contains(iter.next());
            }
        }
        if (result) {
            result = this.getRestletMethod().equals(restletMethod);
        }
        if (result) {
            result = this.isCompatibleRequestEntity(requestEntity, metadataService, converterService);
        }
        return result;
    }

    public boolean isCompatibleRequestEntity(Representation requestEntity, MetadataService metadataService, ConverterService converterService) {
        boolean result = true;
        if (requestEntity != null && requestEntity.isAvailable()) {
            List<Variant> requestVariants = this.getRequestVariants(metadataService, converterService);
            if (requestVariants != null && !requestVariants.isEmpty()) {
                result = false;
                for (int i = 0; !result && i < requestVariants.size(); ++i) {
                    result = requestVariants.get(i).isCompatible(requestEntity);
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    public String toString() {
        return "AnnotationInfo [javaMethod: " + this.javaMethod + ", resourceInterface: " + this.resourceClass + ", restletMethod: " + this.restletMethod + ", input: " + this.getInput() + ", output: " + this.getOutput() + ", query: " + this.getQuery() + "]";
    }
}

