/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.util;

import java.util.Date;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.Reference;
import org.restlet.data.ServerInfo;
import org.restlet.data.Status;
import org.restlet.engine.util.DateUtils;
import org.restlet.representation.Representation;
import org.restlet.util.Resolver;

public class CallResolver
extends Resolver<Object> {
    private final Request request;
    private final Response response;

    public CallResolver(Request request, Response response) {
        this.request = request;
        this.response = response;
    }

    @Override
    public Object resolve(String variableName) {
        Object result;
        Object v0 = result = this.response != null ? this.response.getAttributes().get(variableName) : null;
        if (result != null) {
            return result;
        }
        Object v1 = result = this.request != null ? this.request.getAttributes().get(variableName) : null;
        if (result != null) {
            return result;
        }
        if (variableName == null) {
            return null;
        }
        if (this.request != null) {
            ChallengeResponse cr = this.request.getChallengeResponse();
            Representation entity = this.request.getEntity();
            switch (variableName) {
                case "c": {
                    return Boolean.toString(this.request.isConfidential());
                }
                case "cia": {
                    return this.request.getClientInfo().getAddress();
                }
                case "ciua": {
                    return this.request.getClientInfo().getUpstreamAddress();
                }
                case "cig": {
                    return this.request.getClientInfo().getAgent();
                }
                case "cri": {
                    return cr != null ? cr.getIdentifier() : null;
                }
                case "crs": {
                    return cr != null && cr.getScheme() != null ? cr.getScheme().getTechnicalName() : null;
                }
                case "d": {
                    return DateUtils.format(new Date(), DateUtils.FORMAT_RFC_1123.get(0));
                }
                case "ecs": {
                    return entity != null && entity.getCharacterSet() != null ? entity.getCharacterSet().getName() : null;
                }
                case "ee": {
                    return this.getEncodingsAsString(entity);
                }
                case "eed": {
                    return this.getExpirationDateAsString(entity);
                }
                case "el": {
                    return this.getLanguagesAsString(entity);
                }
                case "emd": {
                    return this.getModificationDateAsString(entity);
                }
                case "emt": {
                    return entity != null && entity.getMediaType() != null ? entity.getMediaType().getName() : null;
                }
                case "es": {
                    return entity != null && entity.getSize() != -1L ? Long.toString(entity.getSize()) : null;
                }
                case "et": {
                    return entity != null && entity.getTag() != null ? entity.getTag().getName() : null;
                }
                case "f": {
                    return this.getReferenceContent(variableName.substring(1), this.request.getReferrerRef());
                }
                case "h": {
                    return this.getReferenceContent(variableName.substring(1), this.request.getHostRef());
                }
                case "m": {
                    return this.request.getMethod() != null ? this.request.getMethod().getName() : null;
                }
                case "p": {
                    return this.request.getProtocol() != null ? this.request.getProtocol().getName() : null;
                }
            }
            if (variableName.startsWith("o")) {
                return this.getReferenceContent(variableName.substring(1), this.request.getRootRef());
            }
            if (variableName.startsWith("r")) {
                return this.getReferenceContent(variableName.substring(1), this.request.getResourceRef());
            }
        }
        if (this.response != null) {
            Representation entity = this.response.getEntity();
            Status status = this.response.getStatus();
            ServerInfo serverInfo = this.response.getServerInfo();
            switch (variableName) {
                case "ECS": {
                    return entity != null && entity.getCharacterSet() != null ? entity.getCharacterSet().getName() : null;
                }
                case "EE": {
                    return this.getEncodingsAsString(entity);
                }
                case "EED": {
                    return this.getExpirationDateAsString(entity);
                }
                case "EL": {
                    return this.getLanguagesAsString(entity);
                }
                case "EMD": {
                    return this.getModificationDateAsString(entity);
                }
                case "EMT": {
                    return entity != null && entity.getMediaType() != null ? entity.getMediaType().getName() : null;
                }
                case "ES": {
                    return entity != null && entity.getSize() != -1L ? Long.toString(entity.getSize()) : null;
                }
                case "ET": {
                    return entity != null && entity.getTag() != null ? entity.getTag().getName() : null;
                }
                case "S": {
                    return status != null ? Integer.toString(status.getCode()) : null;
                }
                case "SIA": {
                    return serverInfo.getAddress();
                }
                case "SIG": {
                    return serverInfo.getAgent();
                }
                case "SIP": {
                    return serverInfo.getPort() != -1 ? Integer.toString(serverInfo.getPort()) : null;
                }
            }
            if (variableName.startsWith("R")) {
                return this.getReferenceContent(variableName.substring(1), this.response.getLocationRef());
            }
        }
        return null;
    }

    private String getReferenceContent(String partName, Reference reference) {
        if (reference == null || partName == null) {
            return null;
        }
        switch (partName) {
            case "a": {
                return reference.getAuthority();
            }
            case "e": {
                return reference.getRelativePart();
            }
            case "f": {
                return reference.getFragment();
            }
            case "h": {
                return reference.getHostIdentifier();
            }
            case "i": {
                return reference.getIdentifier();
            }
            case "p": {
                return reference.getPath();
            }
            case "q": {
                return reference.getQuery();
            }
            case "r": {
                return reference.getRemainingPart();
            }
        }
        if (partName.startsWith("b")) {
            return this.getReferenceContent(partName.substring(1), reference.getBaseRef());
        }
        if (partName.startsWith("t")) {
            return this.getReferenceContent(partName.substring(1), reference.getTargetRef());
        }
        if (partName.isEmpty()) {
            return reference.toString(false, false);
        }
        return null;
    }

    private Object getModificationDateAsString(Representation entity) {
        return entity != null && entity.getModificationDate() != null ? DateUtils.format(entity.getModificationDate(), DateUtils.FORMAT_RFC_1123.get(0)) : null;
    }

    private Object getExpirationDateAsString(Representation entity) {
        return entity != null && entity.getExpirationDate() != null ? DateUtils.format(entity.getExpirationDate(), DateUtils.FORMAT_RFC_1123.get(0)) : null;
    }

    private Object getLanguagesAsString(Representation entity) {
        if (entity != null && !entity.getLanguages().isEmpty()) {
            StringBuilder value = new StringBuilder();
            for (int i = 0; i < entity.getLanguages().size(); ++i) {
                if (i > 0) {
                    value.append(", ");
                }
                value.append(entity.getLanguages().get(i).getName());
            }
            return value.toString();
        }
        return null;
    }

    private Object getEncodingsAsString(Representation entity) {
        if (entity != null && !entity.getEncodings().isEmpty()) {
            StringBuilder value = new StringBuilder();
            for (int i = 0; i < entity.getEncodings().size(); ++i) {
                if (i > 0) {
                    value.append(", ");
                }
                value.append(entity.getEncodings().get(i).getName());
            }
            return value.toString();
        }
        return null;
    }
}

