/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.rest.ch3;

import java.util.ArrayList;
import java.util.List;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.example.book.rest.ch3.S3Authorized;
import org.restlet.example.book.rest.ch3.S3Object;
import org.restlet.resource.DomRepresentation;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3Bucket
extends S3Authorized {
    private String name;
    private boolean truncated;

    public S3Bucket(String name) {
        this.name = name;
    }

    public Status delete() {
        return S3Bucket.authorizedDelete(this.getUri()).getStatus();
    }

    public String getName() {
        return this.name;
    }

    public List<S3Object> getObjects(String prefix, String marker, String delimiter, Integer maxKeys) {
        ArrayList<S3Object> result = new ArrayList<S3Object>();
        StringBuilder uri = new StringBuilder().append(this.getUri());
        String suffix = "?";
        if (prefix != null) {
            uri.append(suffix).append("prefix=").append(prefix);
            suffix = "&";
        }
        if (marker != null) {
            uri.append(suffix).append("marker=").append(marker);
            suffix = "&";
        }
        if (delimiter != null) {
            uri.append(suffix).append("delimiter=").append(delimiter);
            suffix = "&";
        }
        if (maxKeys != null) {
            uri.append(suffix).append("maxKeys=").append(maxKeys);
            suffix = "&";
        }
        Response response = S3Bucket.authorizedGet(uri.toString());
        DomRepresentation document = response.getEntityAsDom();
        this.truncated = document.getNodes("//IsTruncated").get(0).getTextContent().equals("true");
        for (Node node : document.getNodes("//Contents/Key")) {
            result.add(new S3Object(this, node.getTextContent()));
        }
        return result;
    }

    public String getUri() {
        return "https://s3.amazonaws.com/" + this.getName();
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public Status save() {
        return S3Bucket.authorizedPut(this.getUri(), null).getStatus();
    }

    public void setName(String name) {
        this.name = name;
    }
}

