/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch10;

import org.restlet.Restlet;
import org.restlet.data.Cookie;
import org.restlet.data.CookieSetting;
import org.restlet.data.Preference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.resource.StringRepresentation;

public class CookiesRestlet
extends Restlet {
    public void handle(Request request, Response response) {
        for (Preference preference : request.getClientInfo().getAcceptedMediaTypes()) {
            System.out.println(preference.getMetadata());
            System.out.println(preference.getQuality());
        }
        StringBuilder resp = new StringBuilder();
        if (!request.getCookies().isEmpty()) {
            resp.append("Cookies sent by client: ");
            for (Cookie cookie : request.getCookies()) {
                resp.append("[").append(cookie.getName());
                resp.append("/");
                resp.append(cookie.getValue()).append("]");
            }
        } else {
            resp.append("No Cookies sent by client.");
            CookieSetting cookieSetting = new CookieSetting(0, "IP", request.getClientInfo().getAddress());
            cookieSetting.setMaxAge(-1);
            response.getCookieSettings().add((Object)cookieSetting);
        }
        response.setEntity((Representation)new StringRepresentation((CharSequence)resp.toString()));
        response.setStatus(Status.SUCCESS_OK);
    }
}

