/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch10;

import java.io.OutputStream;
import java.util.Collection;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.data.Cookie;
import org.restlet.data.CookieSetting;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.example.book.restlet.ch10.CookiesRestlet;
import org.restlet.example.book.restlet.ch10.DirectoryApplication;
import org.restlet.example.book.restlet.ch10.DynamicApplication;
import org.restlet.example.book.restlet.ch10.NonStandardMethodsApplication;
import org.restlet.example.book.restlet.ch10.TunnelApplication;
import org.restlet.example.book.restlet.ch10.XmlApplication;
import org.restlet.resource.DomRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.SaxRepresentation;
import org.restlet.resource.StringRepresentation;
import org.restlet.util.NodeSet;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SampleComponent {
    public static void main(String[] args) throws Exception {
        Component component = new Component();
        component.getServers().add(Protocol.HTTP, 8182);
        component.getClients().add(Protocol.FILE);
        component.getDefaultHost().attach("/directoryApplication", (Restlet)new DirectoryApplication());
        component.getDefaultHost().attach("/dynamicApplication", (Restlet)new DynamicApplication());
        component.getDefaultHost().attach("/xmlApplication", (Restlet)new XmlApplication());
        component.getDefaultHost().attach("/cookiesRestlet", (Restlet)new CookiesRestlet());
        component.getDefaultHost().attach("/tunnelApplication", (Restlet)new TunnelApplication());
        component.getDefaultHost().attach("/nonStandardMethodsApplication", (Restlet)new NonStandardMethodsApplication());
        component.start();
        Client client = new Client(Protocol.HTTP);
        Response response = client.get("http://localhost:8182/xmlApplication/xml/mail.xml");
        if (response.getStatus().isSuccess() && response.isEntityAvailable()) {
            DomRepresentation domRep = response.getEntityAsDom();
            NodeSet nodes = domRep.getNodes("/mail/recipients/to/text()");
            for (Node node : nodes) {
                System.out.println(node.getNodeValue());
            }
            response = client.get("http://localhost:8182/xmlApplication/xml/mail.xsd");
            if (response.getStatus().isSuccess() && response.isEntityAvailable()) {
                domRep.validate(response.getEntity());
            }
        }
        if ((response = client.get("http://localhost:8182/xmlApplication/xml/mail.xml")).getStatus().isSuccess() && response.isEntityAvailable()) {
            SaxRepresentation saxRep = response.getEntityAsSax();
            DefaultHandler contentHandler = new DefaultHandler(){

                public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                    System.out.println("processing element : " + name);
                }
            };
            saxRep.parse((ContentHandler)contentHandler);
        }
        response = client.get("http://localhost:8182/cookiesRestlet");
        for (CookieSetting cookieSetting : response.getCookieSettings()) {
            System.out.print("[");
            System.out.print(cookieSetting.getName());
            System.out.print("/");
            System.out.print(cookieSetting.getValue());
            System.out.print("]");
        }
        Request request = new Request(Method.GET, "http://localhost:8182/cookiesRestlet");
        request.getCookies().addAll((Collection)response.getCookieSettings());
        request.getCookies().add((Object)new Cookie("test", "value"));
        response = client.handle(request);
        response.getEntity().write((OutputStream)System.out);
        request = new Request(new Method("TEST"), "http://localhost:8182/nonStandardMethodsApplication");
        request.setEntity((Representation)new StringRepresentation((CharSequence)"Test non standard method."));
        response = client.handle(request);
        System.out.println(response.getStatus());
        response.getEntity().write((OutputStream)System.out);
    }
}

