/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch8;

import freemarker.template.Configuration;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Directory;
import org.restlet.Restlet;
import org.restlet.Router;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.LocalReference;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Response;
import org.restlet.example.book.restlet.ch8.RmepGuard;
import org.restlet.example.book.restlet.ch8.data.db4o.Db4oFacade;
import org.restlet.example.book.restlet.ch8.objects.ObjectsFacade;
import org.restlet.example.book.restlet.ch8.resources.ContactResource;
import org.restlet.example.book.restlet.ch8.resources.ContactsResource;
import org.restlet.example.book.restlet.ch8.resources.FeedResource;
import org.restlet.example.book.restlet.ch8.resources.FeedsResource;
import org.restlet.example.book.restlet.ch8.resources.MailResource;
import org.restlet.example.book.restlet.ch8.resources.MailRootResource;
import org.restlet.example.book.restlet.ch8.resources.MailboxResource;
import org.restlet.example.book.restlet.ch8.resources.MailboxesResource;
import org.restlet.example.book.restlet.ch8.resources.MailsResource;
import org.restlet.example.book.restlet.ch8.resources.UserResource;
import org.restlet.example.book.restlet.ch8.resources.UsersResource;

public class Application
extends org.restlet.Application {
    private final ObjectsFacade dataFacade;
    private Configuration fmc;
    private final String dbFilePath;
    private final String webRootPath;

    public static Properties getProperties(String propertiesUri) throws IOException {
        Reference reference = new Reference(propertiesUri);
        Response response = new Client(reference.getSchemeProtocol()).get(reference);
        if (!response.getStatus().isSuccess() || !response.isEntityAvailable()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot access to the configuration file: \"");
            stringBuilder.append(propertiesUri);
            stringBuilder.append("\"");
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        Properties properties = new Properties();
        properties.load(response.getEntity().getStream());
        return properties;
    }

    public static void main(String ... args) throws Exception {
        Component component = new Component();
        component.getServers().add(Protocol.HTTP, 8585);
        component.getClients().add(Protocol.FILE);
        component.getClients().add(Protocol.CLAP);
        component.getClients().add(Protocol.HTTP);
        component.getDefaultHost().attach("/rmep", (Restlet)new Application());
        component.start();
    }

    public Application() throws IOException {
        this.getConnectorService().getClientProtocols().add(Protocol.FILE);
        this.getConnectorService().getClientProtocols().add(Protocol.CLAP);
        this.getConnectorService().getClientProtocols().add(Protocol.HTTP);
        Properties properties = Application.getProperties("clap://class/config/mailApplication.properties");
        this.dbFilePath = properties.getProperty("db4o.file.path");
        this.webRootPath = properties.getProperty("web.root.path");
        this.dataFacade = new ObjectsFacade(new Db4oFacade(this.dbFilePath));
        this.dataFacade.initAdmin();
        try {
            File templateDir = new File(this.webRootPath + "/tmpl");
            this.fmc = new Configuration();
            this.fmc.setDirectoryForTemplateLoading(templateDir);
        }
        catch (Exception e) {
            this.getLogger().severe("Unable to configure FreeMarker.");
            e.printStackTrace();
        }
        this.getMetadataService().addExtension("xml", (Metadata)MediaType.APPLICATION_ATOM_XML, true);
    }

    public Restlet createRoot() {
        Router router = new Router(this.getContext());
        RmepGuard guard = new RmepGuard(this.getContext(), ChallengeScheme.HTTP_BASIC, "rmep", this.dataFacade);
        guard.setNext(MailRootResource.class);
        router.attachDefault((Restlet)guard);
        Directory imgDirectory = new Directory(this.getContext(), (Reference)LocalReference.createFileReference((String)(this.webRootPath + "/images")));
        router.attach("/images", (Restlet)imgDirectory);
        Directory cssDirectory = new Directory(this.getContext(), (Reference)LocalReference.createFileReference((String)(this.webRootPath + "/stylesheets")));
        router.attach("/stylesheets", (Restlet)cssDirectory);
        router.attach("/users", UsersResource.class);
        router.attach("/users/{userId}", UserResource.class);
        router.attach("/mailboxes", MailboxesResource.class);
        Router mailboxRouter = new Router(this.getContext());
        mailboxRouter.attachDefault(MailboxResource.class);
        mailboxRouter.attach("/contacts", ContactsResource.class);
        mailboxRouter.attach("/contacts/{contactId}", ContactResource.class);
        mailboxRouter.attach("/mails", MailsResource.class);
        mailboxRouter.attach("/mails/{mailId}", MailResource.class);
        mailboxRouter.attach("/feeds", FeedsResource.class);
        mailboxRouter.attach("/feeds/{feedId}", FeedResource.class);
        router.attach("/mailboxes/{mailboxId}", (Restlet)mailboxRouter);
        return router;
    }

    public Configuration getFmc() {
        return this.fmc;
    }

    public ObjectsFacade getObjectsFacade() {
        return this.dataFacade;
    }
}

