/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch8.data.db4o;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.Configuration;
import com.db4o.query.Predicate;
import com.db4o.query.QueryComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.restlet.example.book.restlet.ch8.data.DataFacade;
import org.restlet.example.book.restlet.ch8.objects.Contact;
import org.restlet.example.book.restlet.ch8.objects.Feed;
import org.restlet.example.book.restlet.ch8.objects.Mail;
import org.restlet.example.book.restlet.ch8.objects.Mailbox;
import org.restlet.example.book.restlet.ch8.objects.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Db4oFacade
extends DataFacade {
    protected ObjectContainer objectContainer;

    public Db4oFacade(String db4oFilePath) {
        Configuration config = Db4o.newConfiguration();
        config.updateDepth(2);
        config.activationDepth(10);
        this.objectContainer = Db4o.openFile((String)db4oFilePath);
    }

    @Override
    public Contact createContact(Contact contact) {
        contact.setId(Long.toString(new Date().getTime()));
        this.objectContainer.store((Object)contact);
        this.objectContainer.commit();
        return contact;
    }

    @Override
    public Feed createFeed(Feed feed) {
        feed.setId(Long.toString(new Date().getTime()));
        this.objectContainer.store((Object)feed);
        this.objectContainer.commit();
        return feed;
    }

    @Override
    public Mail createMail(Mail mail) {
        mail.setId(Long.toString(new Date().getTime()));
        this.objectContainer.store((Object)mail);
        this.objectContainer.commit();
        return mail;
    }

    @Override
    public void createMailbox(Mailbox mailbox) {
        this.objectContainer.store((Object)mailbox);
        this.objectContainer.commit();
    }

    @Override
    public void createUser(User user) {
        this.objectContainer.store((Object)user);
        this.objectContainer.commit();
    }

    @Override
    public void deleteContact(Contact contact) {
        this.objectContainer.delete((Object)contact);
        this.objectContainer.commit();
    }

    @Override
    public void deleteFeed(Feed feed) {
        this.objectContainer.delete((Object)feed);
        this.objectContainer.commit();
    }

    @Override
    public void deleteMail(Mail mail) {
        this.objectContainer.delete((Object)mail);
        this.objectContainer.commit();
    }

    @Override
    public void deleteMailbox(Mailbox mailbox) {
        this.objectContainer.delete((Object)mailbox);
        this.objectContainer.commit();
    }

    @Override
    public void deleteUser(User user) {
        this.objectContainer.delete((Object)user);
        this.objectContainer.commit();
    }

    private Contact getContact(Contact prototype) {
        Contact contact = null;
        ObjectSet result = this.objectContainer.queryByExample((Object)prototype);
        if (!result.isEmpty()) {
            contact = (Contact)result.get(0);
        }
        return contact;
    }

    @Override
    public Contact getContactById(String contactId) {
        Contact prototype = new Contact();
        prototype.setId(contactId);
        return this.getContact(prototype);
    }

    private Feed getFeed(Feed prototype) {
        Feed feed = null;
        ObjectSet result = this.objectContainer.queryByExample((Object)prototype);
        if (!result.isEmpty()) {
            feed = (Feed)result.get(0);
        }
        return feed;
    }

    @Override
    public Feed getFeedById(String feedId) {
        Feed prototype = new Feed();
        prototype.setId(feedId);
        return this.getFeed(prototype);
    }

    private Mail getMail(Mail prototype) {
        Mail mail = null;
        ObjectSet result = this.objectContainer.queryByExample((Object)prototype);
        if (!result.isEmpty()) {
            mail = (Mail)result.get(0);
        }
        return mail;
    }

    private Mailbox getMailbox(Mailbox prototype) {
        Mailbox mailbox = null;
        ObjectSet result = this.objectContainer.queryByExample((Object)prototype);
        if (!result.isEmpty()) {
            mailbox = (Mailbox)result.get(0);
        }
        return mailbox;
    }

    @Override
    public Mailbox getMailboxById(String mailboxId) {
        Mailbox prototype = new Mailbox();
        prototype.setId(mailboxId);
        return this.getMailbox(prototype);
    }

    @Override
    public List<Mailbox> getMailboxes() {
        Predicate<Mailbox> predicate = new Predicate<Mailbox>(){
            static final long serialVersionUID = 1L;

            public boolean match(Mailbox arg0) {
                return true;
            }
        };
        QueryComparator<Mailbox> comparator = new QueryComparator<Mailbox>(){
            static final long serialVersionUID = 1L;

            public int compare(Mailbox arg0, Mailbox arg1) {
                int result = arg0.getOwner().getLastName().compareToIgnoreCase(arg1.getOwner().getLastName());
                if (result == 0) {
                    result = arg0.getNickname().compareToIgnoreCase(arg1.getNickname());
                }
                return result;
            }
        };
        ArrayList<Mailbox> result = new ArrayList<Mailbox>();
        ObjectSet list = this.objectContainer.query((Predicate)predicate, (QueryComparator)comparator);
        result.addAll((Collection<Mailbox>)list);
        return result;
    }

    @Override
    public List<Mailbox> getMailboxes(User user) {
        final String userId = user.getId();
        Predicate<Mailbox> predicate = new Predicate<Mailbox>(){
            static final long serialVersionUID = 1L;

            public boolean match(Mailbox mailbox) {
                return mailbox.getOwner().getId().equals(userId);
            }
        };
        return new ArrayList<Mailbox>((Collection<Mailbox>)this.objectContainer.query((Predicate)predicate));
    }

    @Override
    public Mail getMailById(String mailId) {
        Mail prototype = new Mail();
        prototype.setId(mailId);
        return this.getMail(prototype);
    }

    private User getUser(User prototype) {
        User user = null;
        ObjectSet result = this.objectContainer.queryByExample((Object)prototype);
        if (!result.isEmpty()) {
            user = (User)result.get(0);
        }
        return user;
    }

    @Override
    public User getUserById(String userId) {
        User prototype = new User();
        prototype.setId(userId);
        return this.getUser(prototype);
    }

    @Override
    public User getUserByLoginPwd(String login, char[] password) {
        User prototype = new User();
        prototype.setLogin(login);
        prototype.setPassword(new String(password));
        return this.getUser(prototype);
    }

    @Override
    public List<User> getUsers() {
        Predicate<User> predicate = new Predicate<User>(){
            static final long serialVersionUID = 1L;

            public boolean match(User arg0) {
                return true;
            }
        };
        QueryComparator<User> comparator = new QueryComparator<User>(){
            static final long serialVersionUID = 1L;

            public int compare(User arg0, User arg1) {
                return arg0.getLastName().compareToIgnoreCase(arg1.getLastName());
            }
        };
        ArrayList<User> result = new ArrayList<User>();
        ObjectSet list = this.objectContainer.query((Predicate)predicate, (QueryComparator)comparator);
        result.addAll((Collection<User>)list);
        return result;
    }

    @Override
    public void initAdmin() {
        User prototype = new User();
        prototype.setAdministrator(true);
        ObjectSet result = this.objectContainer.queryByExample((Object)prototype);
        if (result.isEmpty()) {
            prototype.setId("admin");
            prototype.setFirstName("admin");
            prototype.setLastName("admin");
            prototype.setLogin("admin");
            prototype.setPassword("admin");
            prototype.setAdministrator(true);
            this.createUser(prototype);
        }
    }

    @Override
    public void updateContact(Contact contact) {
        this.objectContainer.store((Object)contact);
        this.objectContainer.commit();
    }

    @Override
    public void updateFeed(Feed feed) {
        this.objectContainer.store((Object)feed);
        this.objectContainer.commit();
    }

    @Override
    public void updateMail(Mail mail) {
        this.objectContainer.store((Object)mail);
        this.objectContainer.commit();
    }

    @Override
    public void updateMailbox(Mailbox mailbox) {
        this.objectContainer.store((Object)mailbox);
        this.objectContainer.commit();
    }

    @Override
    public void updateUser(User user) {
        this.objectContainer.store((Object)user);
        this.objectContainer.commit();
    }
}

