/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch8.resources;

import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.example.book.restlet.ch8.objects.Feed;
import org.restlet.example.book.restlet.ch8.objects.Mailbox;
import org.restlet.example.book.restlet.ch8.resources.BaseResource;
import org.restlet.resource.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;

public class FeedsResource
extends BaseResource {
    private Mailbox mailbox;
    private List<Feed> feeds;

    public FeedsResource(Context context, Request request, Response response) {
        super(context, request, response);
        if (this.getCurrentUser() != null) {
            this.setModifiable(true);
            String mailboxId = Reference.decode((String)((String)request.getAttributes().get("mailboxId")));
            this.mailbox = this.getObjectsFacade().getMailboxById(mailboxId);
            if (this.mailbox != null) {
                this.feeds = this.mailbox.getFeeds();
                this.getVariants().add(new Variant(MediaType.TEXT_HTML));
            }
        } else {
            this.setModifiable(false);
        }
    }

    public void acceptRepresentation(Representation entity) throws ResourceException {
        Form form = new Form(entity);
        Feed feed = new Feed();
        feed.setNickname(form.getFirstValue("nickname"));
        feed.setTags(Arrays.asList(form.getFirstValue("tags").split(" ")));
        feed = this.getObjectsFacade().createFeed(this.mailbox, feed);
        this.getResponse().redirectSeeOther(this.getChildReference(this.getRequest().getResourceRef(), feed.getId()));
    }

    public boolean allowPost() {
        return true;
    }

    public Representation represent(Variant variant) throws ResourceException {
        TreeMap<String, Object> dataModel = new TreeMap<String, Object>();
        dataModel.put("currentUser", this.getCurrentUser());
        dataModel.put("mailbox", this.mailbox);
        dataModel.put("feeds", this.feeds);
        dataModel.put("resourceRef", this.getRequest().getResourceRef());
        dataModel.put("rootRef", this.getRequest().getRootRef());
        return this.getHTMLTemplateRepresentation("feeds.html", dataModel);
    }
}

