/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch8.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.TreeMap;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.example.book.restlet.ch8.objects.Contact;
import org.restlet.example.book.restlet.ch8.objects.Mail;
import org.restlet.example.book.restlet.ch8.objects.Mailbox;
import org.restlet.example.book.restlet.ch8.resources.BaseResource;
import org.restlet.resource.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;

public class MailResource
extends BaseResource {
    private Mail mail;
    private Mailbox mailbox;

    public MailResource(Context context, Request request, Response response) {
        super(context, request, response);
        if (this.getCurrentUser() != null) {
            this.setModifiable(true);
            String mailboxId = Reference.decode((String)((String)request.getAttributes().get("mailboxId")));
            this.mailbox = this.getObjectsFacade().getMailboxById(mailboxId);
            if (this.mailbox != null) {
                String mailId = (String)request.getAttributes().get("mailId");
                this.mail = this.getObjectsFacade().getMailById(mailId);
                if (this.mail != null) {
                    this.getVariants().add(new Variant(MediaType.TEXT_HTML));
                }
            }
        } else {
            this.setModifiable(false);
        }
    }

    public void removeRepresentations() throws ResourceException {
        this.getObjectsFacade().deleteMail(this.mailbox, this.mail);
        this.getResponse().redirectSeeOther(this.getRequest().getResourceRef().getParentRef());
    }

    public Representation represent(Variant variant) throws ResourceException {
        TreeMap<String, Object> dataModel = new TreeMap<String, Object>();
        dataModel.put("currentUser", this.getCurrentUser());
        dataModel.put("mailbox", this.mailbox);
        dataModel.put("mail", this.mail);
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        contacts.addAll(this.mailbox.getContacts());
        if (this.mail.getRecipients() != null) {
            for (Contact contact : this.mail.getRecipients()) {
                if (contact.getId() != null) continue;
                contacts.add(contact);
            }
        }
        dataModel.put("contacts", contacts);
        dataModel.put("resourceRef", this.getRequest().getResourceRef());
        dataModel.put("rootRef", this.getRequest().getRootRef());
        return this.getHTMLTemplateRepresentation("mail_" + this.mail.getStatus() + ".html", dataModel);
    }

    public void storeRepresentation(Representation entity) throws ResourceException {
        Form form = new Form(entity);
        ArrayList<String> mailAddresses = new ArrayList<String>();
        for (Parameter parameter : form.subList("recipients")) {
            mailAddresses.add(parameter.getValue());
        }
        ArrayList<String> tags = null;
        if (form.getFirstValue("tags") != null) {
            tags = new ArrayList<String>(Arrays.asList(form.getFirstValue("tags").split(" ")));
        }
        this.getObjectsFacade().updateMail(this.mailbox, this.mail, form.getFirstValue("status"), form.getFirstValue("subject"), form.getFirstValue("message"), mailAddresses, tags);
        if ("sending".equalsIgnoreCase(this.mail.getStatus())) {
            this.mail.setSendingDate(new Date());
            boolean success = true;
            if (this.mail.getRecipients() != null) {
                Client client = new Client(Protocol.HTTP);
                Form form2 = new Form();
                form2.add("status", "receiving");
                form2.add("senderAddress", this.getRequest().getRootRef() + "/mailboxes/" + this.mailbox.getId());
                form2.add("senderName", this.mailbox.getSenderName());
                form2.add("subject", this.mail.getSubject());
                form2.add("message", this.mail.getMessage());
                form2.add("sendingDate", this.mail.getSendingDate().toString());
                for (Contact recipient : this.mail.getRecipients()) {
                    form2.add("recipient", recipient.getMailAddress() + "$" + recipient.getName());
                }
                StringBuilder builder = new StringBuilder();
                Request request = new Request();
                request.setMethod(Method.POST);
                for (Contact contact : this.mail.getRecipients()) {
                    request.setResourceRef(contact.getMailAddress());
                    request.setEntity(form2.getWebRepresentation());
                    Response response = client.handle(request);
                    if (response.getStatus().isSuccess()) continue;
                    success = false;
                    builder.append(contact.getName());
                    builder.append("\t");
                    builder.append(response.getStatus());
                }
                if (success) {
                    this.mail.setStatus("sent");
                    this.getObjectsFacade().updateMail(this.mailbox, this.mail);
                    this.getResponse().redirectSeeOther(this.getRequest().getResourceRef());
                } else {
                    TreeMap<String, Object> dataModel = new TreeMap<String, Object>();
                    dataModel.put("currentUser", this.getCurrentUser());
                    dataModel.put("mailbox", this.mailbox);
                    dataModel.put("mail", this.mail);
                    dataModel.put("resourceRef", this.getRequest().getResourceRef());
                    dataModel.put("rootRef", this.getRequest().getRootRef());
                    dataModel.put("message", builder.toString());
                    this.getResponse().setEntity(this.getHTMLTemplateRepresentation("mail_" + this.mail.getStatus() + ".html", dataModel));
                }
            } else {
                this.mail.setStatus("draft");
                this.getObjectsFacade().updateMail(this.mailbox, this.mail);
                this.getResponse().redirectSeeOther(this.getRequest().getResourceRef());
            }
        } else {
            this.getResponse().redirectSeeOther(this.getRequest().getResourceRef());
        }
    }
}

