/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch8.resources;

import java.util.TreeMap;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.example.book.restlet.ch8.objects.Contact;
import org.restlet.example.book.restlet.ch8.objects.Mail;
import org.restlet.example.book.restlet.ch8.objects.Mailbox;
import org.restlet.example.book.restlet.ch8.resources.BaseResource;
import org.restlet.resource.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.restlet.util.Series;

public class MailboxResource
extends BaseResource {
    private final Mailbox mailbox;

    public MailboxResource(Context context, Request request, Response response) {
        super(context, request, response);
        String mailboxId = Reference.decode((String)((String)request.getAttributes().get("mailboxId")), (CharacterSet)CharacterSet.ISO_8859_1);
        this.mailbox = this.getObjectsFacade().getMailboxById(mailboxId);
        System.out.println(Reference.encode((String)mailboxId));
        if (this.mailbox != null) {
            this.getVariants().add(new Variant(MediaType.TEXT_HTML));
        }
        this.setModifiable(true);
    }

    public void acceptRepresentation(Representation entity) throws ResourceException {
        Form form = new Form(entity);
        Mail mail = new Mail();
        mail.setStatus("received");
        String senderAddress = form.getFirstValue("senderAddress");
        String senderName = form.getFirstValue("senderName");
        Contact contact = this.getObjectsFacade().lookForContact(senderAddress, this.mailbox);
        if (contact == null) {
            contact = new Contact();
            contact.setMailAddress(senderAddress);
            contact.setName(senderName);
        }
        mail.setSender(contact);
        mail.setMessage(form.getFirstValue("message"));
        mail.setSubject(form.getFirstValue("subject"));
        Series recipients = form.subList("recipient");
        for (Parameter recipient : recipients) {
            contact = this.getObjectsFacade().lookForContact(recipient.getValue(), this.mailbox);
            if (contact == null) {
                contact = new Contact();
                String[] recipientValues = recipient.getValue().split("\\$");
                contact.setMailAddress(recipientValues[0]);
                contact.setName(recipientValues[1]);
            }
            mail.getRecipients().add(contact);
        }
        this.getObjectsFacade().createMail(this.mailbox, mail);
    }

    public void removeRepresentations() throws ResourceException {
        this.getObjectsFacade().deleteMailbox(this.mailbox);
        this.getResponse().redirectSeeOther(this.getRequest().getResourceRef().getParentRef());
    }

    public Representation represent(Variant variant) throws ResourceException {
        TreeMap<String, Object> dataModel = new TreeMap<String, Object>();
        dataModel.put("currentUser", this.getCurrentUser());
        dataModel.put("mailbox", this.mailbox);
        dataModel.put("resourceRef", this.getRequest().getResourceRef());
        dataModel.put("rootRef", this.getRequest().getRootRef());
        return this.getHTMLTemplateRepresentation("mailbox.html", dataModel);
    }

    public void storeRepresentation(Representation entity) throws ResourceException {
        Form form = new Form(entity);
        this.mailbox.setNickname(form.getFirstValue("nickname"));
        this.mailbox.setSenderName(form.getFirstValue("senderName"));
        this.getObjectsFacade().updateMailbox(this.mailbox);
        this.getResponse().redirectSeeOther(this.getRequest().getResourceRef());
    }
}

