/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch8.resources;

import java.util.List;
import java.util.TreeMap;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.example.book.restlet.ch8.objects.Mailbox;
import org.restlet.example.book.restlet.ch8.objects.ObjectsException;
import org.restlet.example.book.restlet.ch8.objects.User;
import org.restlet.example.book.restlet.ch8.resources.BaseResource;
import org.restlet.resource.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;

public class MailboxesResource
extends BaseResource {
    private List<Mailbox> mailboxes;
    private List<User> users;

    public MailboxesResource(Context context, Request request, Response response) {
        super(context, request, response);
        if (this.getCurrentUser() != null) {
            if (this.getCurrentUser().isAdministrator()) {
                this.mailboxes = this.getObjectsFacade().getMailboxes();
                this.users = this.getObjectsFacade().getUsers();
            } else {
                this.mailboxes = this.getObjectsFacade().getMailboxes(this.getCurrentUser());
            }
        }
        this.setModifiable(true);
        this.getVariants().add(new Variant(MediaType.TEXT_HTML));
    }

    public void acceptRepresentation(Representation entity) throws ResourceException {
        Form form = new Form(entity);
        Mailbox mailbox = new Mailbox();
        System.out.println(Reference.decode((String)form.getFirstValue("nickname")));
        mailbox.setNickname(form.getFirstValue("nickname"));
        User owner = this.getObjectsFacade().getUserById(form.getFirstValue("ownerId"));
        mailbox.setOwner(owner);
        mailbox.setSenderName(owner.getFirstName() + " " + owner.getLastName());
        try {
            mailbox = this.getObjectsFacade().createMailbox(mailbox);
            this.getResponse().redirectSeeOther(this.getRequest().getResourceRef());
        }
        catch (ObjectsException e) {
            TreeMap<String, Object> dataModel = new TreeMap<String, Object>();
            dataModel.put("currentUser", this.getCurrentUser());
            dataModel.put("mailboxes", this.mailboxes);
            dataModel.put("users", this.users);
            dataModel.put("resourceRef", this.getRequest().getResourceRef());
            dataModel.put("rootRef", this.getRequest().getRootRef());
            dataModel.put("ownerId", form.getFirstValue("ownerId"));
            dataModel.put("nickname", form.getFirstValue("nickname"));
            dataModel.put("errorMessage", e.getMessage());
            this.getResponse().setEntity(this.getHTMLTemplateRepresentation("mailboxes.html", dataModel));
        }
    }

    public Representation represent(Variant variant) throws ResourceException {
        TreeMap<String, Object> dataModel = new TreeMap<String, Object>();
        dataModel.put("currentUser", this.getCurrentUser());
        dataModel.put("mailboxes", this.mailboxes);
        dataModel.put("users", this.users);
        dataModel.put("resourceRef", this.getRequest().getResourceRef());
        dataModel.put("rootRef", this.getRequest().getRootRef());
        return this.getHTMLTemplateRepresentation("mailboxes.html", dataModel);
    }
}

