/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch8.resources;

import java.util.List;
import java.util.TreeMap;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.example.book.restlet.ch8.objects.Mailbox;
import org.restlet.example.book.restlet.ch8.objects.User;
import org.restlet.example.book.restlet.ch8.resources.BaseResource;
import org.restlet.resource.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;

public class UserResource
extends BaseResource {
    private User user;
    private List<Mailbox> mailboxes;

    public UserResource(Context context, Request request, Response response) {
        super(context, request, response);
        if (this.getCurrentUser() != null) {
            this.setModifiable(true);
            String userId = Reference.decode((String)((String)request.getAttributes().get("userId")));
            this.user = this.getObjectsFacade().getUserById(userId);
            if (this.user != null) {
                this.mailboxes = this.getObjectsFacade().getMailboxes(this.user);
                this.getVariants().add(new Variant(MediaType.TEXT_HTML));
            }
        } else {
            this.setModifiable(false);
        }
    }

    public void removeRepresentations() throws ResourceException {
        this.getObjectsFacade().deleteUser(this.user);
        this.getResponse().redirectSeeOther(this.getRequest().getResourceRef().getParentRef());
    }

    public Representation represent(Variant variant) throws ResourceException {
        TreeMap<String, Object> dataModel = new TreeMap<String, Object>();
        dataModel.put("currentUser", this.getCurrentUser());
        dataModel.put("user", this.user);
        dataModel.put("mailboxes", this.mailboxes);
        dataModel.put("resourceRef", this.getRequest().getResourceRef());
        dataModel.put("rootRef", this.getRequest().getRootRef());
        return this.getHTMLTemplateRepresentation("user.html", dataModel);
    }

    public void storeRepresentation(Representation entity) throws ResourceException {
        Form form = new Form(entity);
        this.user.setAdministrator(form.getFirstValue("administrator") == null ? this.user.isAdministrator() : true);
        this.user.setFirstName(form.getFirstValue("firstName"));
        this.user.setLastName(form.getFirstValue("lastName"));
        this.user.setLogin(form.getFirstValue("login"));
        this.user.setPassword(form.getFirstValue("password"));
        this.getObjectsFacade().updateUser(this.user);
        this.getResponse().redirectSeeOther(this.getRequest().getResourceRef());
    }
}

