/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.wadl;

import java.io.IOException;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.example.ext.wadl.BaseResource;
import org.restlet.example.ext.wadl.Item;
import org.restlet.ext.wadl.FaultInfo;
import org.restlet.ext.wadl.MethodInfo;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.ext.wadl.RepresentationInfo;
import org.restlet.resource.DomRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ItemResource
extends BaseResource {
    Item item;
    String itemName = (String)this.getRequest().getAttributes().get("itemName");

    public ItemResource(Context context, Request request, Response response) {
        super(context, request, response);
        if (this.itemName != null) {
            this.item = (Item)this.getItems().get(this.itemName);
            if (this.item != null) {
                this.getVariants().add(new Variant(MediaType.TEXT_XML));
            } else {
                this.setAvailable(false);
            }
        }
    }

    public boolean allowDelete() {
        return true;
    }

    public boolean allowPut() {
        return true;
    }

    public Representation describe() {
        this.setTitle("Representation a single item");
        return super.describe();
    }

    protected void describeGet(MethodInfo info) {
        info.setIdentifier("item");
        info.setDocumentation("To retrieve details of a specific item");
        RepresentationInfo repInfo = new RepresentationInfo(MediaType.TEXT_XML);
        repInfo.setXmlElement("item");
        repInfo.setDocumentation("XML representation of the current item.");
        info.getResponse().getRepresentations().add(repInfo);
        FaultInfo faultInfo = new FaultInfo(Status.CLIENT_ERROR_NOT_FOUND, "Item not found");
        faultInfo.setIdentifier("itemError");
        faultInfo.setMediaType(MediaType.TEXT_HTML);
        info.getResponse().getFaults().add(faultInfo);
    }

    protected void describeDelete(MethodInfo info) {
        info.setDocumentation("Delete the current item.");
        RepresentationInfo repInfo = new RepresentationInfo();
        repInfo.setDocumentation("No representation is returned.");
        repInfo.getStatuses().add(Status.SUCCESS_NO_CONTENT);
        info.getResponse().getRepresentations().add(repInfo);
    }

    protected void describePut(MethodInfo info) {
        info.setDocumentation("Update or create the current item.");
        RepresentationInfo repInfo = new RepresentationInfo(MediaType.APPLICATION_WWW_FORM);
        ParameterInfo param = new ParameterInfo("name", ParameterStyle.PLAIN, "Name of the item");
        repInfo.getParameters().add(param);
        param = new ParameterInfo("description", ParameterStyle.PLAIN, "Description of the item");
        repInfo.getParameters().add(param);
        repInfo.getStatuses().add(Status.SUCCESS_OK);
        repInfo.getStatuses().add(Status.SUCCESS_CREATED);
        repInfo.setDocumentation("Web form.");
        info.getRequest().getRepresentations().add(repInfo);
        super.describePut(info);
    }

    public void removeRepresentations() throws ResourceException {
        if (this.item != null) {
            this.getItems().remove(this.item.getName());
        }
        this.getResponse().setStatus(Status.SUCCESS_NO_CONTENT);
    }

    public Representation represent(Variant variant) throws ResourceException {
        if (MediaType.TEXT_XML.equals((Object)variant.getMediaType())) {
            try {
                DomRepresentation representation = new DomRepresentation(MediaType.TEXT_XML);
                Document d = representation.getDocument();
                Element eltItem = d.createElement("item");
                d.appendChild(eltItem);
                Element eltName = d.createElement("name");
                eltName.appendChild(d.createTextNode(this.item.getName()));
                eltItem.appendChild(eltName);
                Element eltDescription = d.createElement("description");
                eltDescription.appendChild(d.createTextNode(this.item.getDescription()));
                eltItem.appendChild(eltDescription);
                d.normalizeDocument();
                return representation;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void storeRepresentation(Representation entity) throws ResourceException {
        if (this.item == null) {
            this.item = new Item(this.itemName);
        }
        Form form = new Form(entity);
        this.item.setDescription(form.getFirstValue("description"));
        if (this.getItems().putIfAbsent(this.item.getName(), this.item) == null) {
            this.getResponse().setStatus(Status.SUCCESS_CREATED);
        } else {
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
    }
}

