/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.wadl;

import java.io.IOException;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.example.ext.wadl.BaseResource;
import org.restlet.example.ext.wadl.Item;
import org.restlet.ext.wadl.FaultInfo;
import org.restlet.ext.wadl.MethodInfo;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.ext.wadl.RepresentationInfo;
import org.restlet.resource.DomRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.StringRepresentation;
import org.restlet.resource.Variant;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ItemsResource
extends BaseResource {
    public ItemsResource(Context context, Request request, Response response) {
        super(context, request, response);
        this.getVariants().add(new Variant(MediaType.TEXT_XML));
    }

    public void acceptRepresentation(Representation entity) throws ResourceException {
        Form form = new Form(entity);
        String itemName = form.getFirstValue("name");
        String itemDescription = form.getFirstValue("description");
        if (this.getItems().containsKey(itemName)) {
            this.generateErrorRepresentation("Item " + itemName + " already exists.", "1", this.getResponse());
        } else {
            this.getItems().put(itemName, new Item(itemName, itemDescription));
            this.getResponse().setStatus(Status.SUCCESS_CREATED);
            StringRepresentation rep = new StringRepresentation((CharSequence)"Item created", MediaType.TEXT_PLAIN);
            rep.setIdentifier(this.getRequest().getResourceRef().getIdentifier() + "/" + itemName);
            this.getResponse().setEntity((Representation)rep);
        }
    }

    public boolean allowPost() {
        return true;
    }

    protected Representation describe() {
        this.setTitle("List of items.");
        return super.describe();
    }

    protected void describeGet(MethodInfo info) {
        info.setIdentifier("items");
        info.setDocumentation("Retrieve the list of current items.");
        RepresentationInfo repInfo = new RepresentationInfo(MediaType.TEXT_XML);
        repInfo.setXmlElement("items");
        repInfo.setDocumentation("List of items as XML file");
        info.getResponse().getRepresentations().add(repInfo);
    }

    protected void describePost(MethodInfo info) {
        info.setIdentifier("create_item");
        info.setDocumentation("To create an item.");
        RepresentationInfo repInfo = new RepresentationInfo(MediaType.APPLICATION_WWW_FORM);
        ParameterInfo param = new ParameterInfo("name", ParameterStyle.PLAIN, "Name of the item");
        repInfo.getParameters().add(param);
        param = new ParameterInfo("description", ParameterStyle.PLAIN, "Description of the item");
        repInfo.getParameters().add(param);
        repInfo.getStatuses().add(Status.SUCCESS_CREATED);
        repInfo.setDocumentation("Web form.");
        info.getRequest().getRepresentations().add(repInfo);
        FaultInfo faultInfo = new FaultInfo(Status.CLIENT_ERROR_NOT_FOUND);
        faultInfo.setIdentifier("itemError");
        faultInfo.setMediaType(MediaType.TEXT_HTML);
        info.getResponse().getFaults().add(faultInfo);
    }

    private void generateErrorRepresentation(String errorMessage, String errorCode, Response response) {
        response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        try {
            DomRepresentation representation = new DomRepresentation(MediaType.TEXT_XML);
            Document d = representation.getDocument();
            Element eltError = d.createElement("error");
            Element eltCode = d.createElement("code");
            eltCode.appendChild(d.createTextNode(errorCode));
            eltError.appendChild(eltCode);
            Element eltMessage = d.createElement("message");
            eltMessage.appendChild(d.createTextNode(errorMessage));
            eltError.appendChild(eltMessage);
            response.setEntity((Representation)representation);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Representation represent(Variant variant) throws ResourceException {
        if (MediaType.TEXT_XML.equals((Object)variant.getMediaType())) {
            try {
                DomRepresentation representation = new DomRepresentation(MediaType.TEXT_XML);
                Document d = representation.getDocument();
                Element r = d.createElement("items");
                d.appendChild(r);
                for (Item item : this.getItems().values()) {
                    Element eltItem = d.createElement("item");
                    Element eltName = d.createElement("name");
                    eltName.appendChild(d.createTextNode(item.getName()));
                    eltItem.appendChild(eltName);
                    Element eltDescription = d.createElement("description");
                    eltDescription.appendChild(d.createTextNode(item.getDescription()));
                    eltItem.appendChild(eltDescription);
                    r.appendChild(eltItem);
                }
                d.normalizeDocument();
                return representation;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

