/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.firstResource;

import java.io.IOException;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.example.firstResource.BaseResource;
import org.restlet.example.firstResource.Item;
import org.restlet.resource.DomRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ItemResource
extends BaseResource {
    String itemName = (String)this.getRequest().getAttributes().get("itemName");
    Item item = (Item)this.getItems().get(this.itemName);

    public ItemResource(Context context, Request request, Response response) {
        super(context, request, response);
        if (this.item != null) {
            this.getVariants().add(new Variant(MediaType.TEXT_XML));
            this.setModifiable(true);
        } else {
            this.setAvailable(false);
        }
    }

    public void removeRepresentations() throws ResourceException {
        if (this.item != null) {
            this.getItems().remove(this.item.getName());
        }
        this.getResponse().setStatus(Status.SUCCESS_NO_CONTENT);
    }

    public Representation represent(Variant variant) throws ResourceException {
        if (MediaType.TEXT_XML.equals((Object)variant.getMediaType())) {
            try {
                DomRepresentation representation = new DomRepresentation(MediaType.TEXT_XML);
                Document d = representation.getDocument();
                Element eltItem = d.createElement("item");
                d.appendChild(eltItem);
                Element eltName = d.createElement("name");
                eltName.appendChild(d.createTextNode(this.item.getName()));
                eltItem.appendChild(eltName);
                Element eltDescription = d.createElement("description");
                eltDescription.appendChild(d.createTextNode(this.item.getDescription()));
                eltItem.appendChild(eltDescription);
                d.normalizeDocument();
                return representation;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void storeRepresentation(Representation entity) throws ResourceException {
        if (this.item == null) {
            this.item = new Item(this.itemName);
        }
        Form form = new Form(entity);
        this.item.setDescription(form.getFirstValue("description"));
        if (this.getItems().putIfAbsent(this.item.getName(), this.item) == null) {
            this.getResponse().setStatus(Status.SUCCESS_CREATED);
        } else {
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
    }
}

