/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.jaxrs.employees;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.restlet.example.jaxrs.employees.Employee;
import org.restlet.example.jaxrs.employees.EmployeeList;
import org.restlet.example.jaxrs.employees.EmployeeMgr;
import org.restlet.example.jaxrs.employees.EmployeeResource;
import org.restlet.example.jaxrs.employees.SmallEmployee;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="employees")
public class EmployeesResource {
    private final EmployeeMgr employeeMgr = EmployeeMgr.get();
    @Context
    private UriInfo uriInfo;

    private URI createdLocation(int staffNo) {
        UriBuilder locBuilder = this.uriInfo.getRequestUriBuilder();
        locBuilder.path("{staffNo}");
        return locBuilder.build(new Object[]{staffNo});
    }

    @POST
    @Consumes(value={"application/xml", "text/xml", "application/json"})
    public Response createEmployee(Employee employee) {
        int staffNo = this.employeeMgr.createEmployee(employee);
        URI location = this.createdLocation(staffNo);
        return Response.created((URI)location).build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response createEmployee(MultivaluedMap<String, String> employeeData) {
        Employee employee = new Employee();
        employee.setFirstname((String)employeeData.getFirst((Object)"firstname"));
        employee.setLastname((String)employeeData.getFirst((Object)"lastname"));
        employee.setSex((String)employeeData.getFirst((Object)"sex"));
        employee.setDepartment((String)employeeData.getFirst((Object)"department"));
        int persNo = this.employeeMgr.createEmployee(employee);
        URI location = this.createdLocation(persNo);
        return Response.seeOther((URI)location).build();
    }

    @GET
    @Produces(value={"application/xml", "text/xml", "application/json"})
    public EmployeeList getEmployees() {
        EmployeeList employees = this.employeeMgr.getAll();
        UriBuilder uriBuilder = this.uriInfo.getRequestUriBuilder();
        uriBuilder.path("{staffNo}");
        for (SmallEmployee employee : employees) {
            employee.setDetails(uriBuilder.build(new Object[]{employee.getStaffNo()}));
        }
        return employees;
    }

    @GET
    @Produces(value={"text/html"})
    public StreamingOutput getListAsHtml() {
        final EmployeeList employees = this.getEmployees();
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException {
                PrintStream ps = new PrintStream(output);
                ps.println("<html><head>");
                ps.println("<title>Employees</title>");
                ps.println("</head></body>");
                ps.println("<h2>Employees</h2>");
                ps.println("<ul>");
                for (SmallEmployee employee : employees) {
                    ps.print("<li><a href=\"");
                    ps.print(employee.getDetails());
                    ps.print("\">");
                    ps.print(employee.getFirstname());
                    ps.print(" ");
                    ps.print(employee.getLastname());
                    ps.print("</a></li>");
                }
                ps.println("</ul>");
                ps.print("<form action=\"");
                ps.print(EmployeesResource.this.uriInfo.getAbsolutePath());
                ps.println("\" method=\"POST\">");
                ps.println("<table><tr>");
                ps.println("<td>firstname:</td>");
                ps.println("<td><input type=\"text\" name=\"firstname\" /></td>");
                ps.println("</tr><tr>");
                ps.println("<td>lastname:</td>");
                ps.println("<td><input type=\"text\" name=\"lastname\" /></td>");
                ps.println("</tr><tr>");
                ps.println("<td>sex:</td>");
                ps.println("<td><input type=\"text\" name=\"sex\" /></td>");
                ps.println("</tr><tr>");
                ps.println("<td>department:</td>");
                ps.println("<td><input type=\"text\" name=\"department\" /></td>");
                ps.println("</tr><tr>");
                ps.println("<td></td>");
                ps.println("<td><input type=\"submit\" value=\"create employee\" /></td>");
                ps.println("</tr></table>");
                ps.println("</form>");
                ps.println("</body></html>");
            }
        };
    }

    @Path(value="{staffNo}")
    public EmployeeResource getSub(@PathParam(value="staffNo") int staffNo) {
        if (!this.employeeMgr.exists(staffNo)) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return new EmployeeResource(staffNo);
    }
}

