/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.misc;

import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class SimpleServer {
    public static void main(String[] args) {
        try {
            Component component = new Component();
            component.getServers().add(Protocol.HTTP, 9876);
            Restlet handler = new Restlet(component.getContext().createChildContext()){

                public void handle(Request request, Response response) {
                    if (request.getMethod().equals((Object)Method.PUT)) {
                        System.out.println("Handling the call...");
                        System.out.println("Trying to get the entity as a form...");
                        Form form = request.getEntityAsForm();
                        System.out.println("Trying to getParameters...");
                        StringBuffer sb = new StringBuffer("foo");
                        for (Parameter p : form) {
                            System.out.println(p);
                            sb.append("field name = ");
                            sb.append(p.getName());
                            sb.append("value = ");
                            sb.append(p.getValue());
                            sb.append("\n");
                            System.out.println(sb.toString());
                        }
                        response.setEntity(sb.toString(), MediaType.TEXT_PLAIN);
                        System.out.println("Done!");
                    } else {
                        response.setStatus(Status.SERVER_ERROR_NOT_IMPLEMENTED);
                    }
                }
            };
            component.getDefaultHost().attach("/test", handler);
            component.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

