/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.JAXBSource;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.sax.SAXSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.resource.Representation;
import org.restlet.resource.StringRepresentation;
import org.restlet.resource.XmlRepresentation;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbRepresentation<T>
extends XmlRepresentation {
    private static final Map<String, JAXBContext> contexts = new TreeMap<String, JAXBContext>();
    private volatile String contextPath;
    private volatile boolean formattedOutput;
    private volatile T object;
    private volatile ValidationEventHandler validationEventHandler;
    private volatile Representation xmlRepresentation;

    private static synchronized JAXBContext getContext(String contextPath) throws JAXBException {
        JAXBContext result = contexts.get(contextPath);
        if (result == null) {
            result = JAXBContext.newInstance((String)contextPath);
            contexts.put(contextPath, result);
        }
        return result;
    }

    public JaxbRepresentation(MediaType mediaType, T object) {
        super(mediaType);
        this.object = object;
        this.contextPath = object != null ? object.getClass().getPackage().getName() : null;
        this.validationEventHandler = null;
        this.xmlRepresentation = null;
    }

    public JaxbRepresentation(Representation xmlRepresentation, Class<T> type) {
        this(xmlRepresentation, type.getPackage().getName(), null);
    }

    public JaxbRepresentation(Representation xmlRepresentation, Class<T> type, ValidationEventHandler validationHandler) {
        this(xmlRepresentation, type.getPackage().getName(), validationHandler);
    }

    public JaxbRepresentation(Representation xmlRepresentation, String contextPath) {
        this(xmlRepresentation, contextPath, null);
    }

    public JaxbRepresentation(Representation xmlRepresentation, String contextPath, ValidationEventHandler validationHandler) {
        super(xmlRepresentation.getMediaType());
        this.contextPath = contextPath;
        this.object = null;
        this.validationEventHandler = validationHandler;
        this.xmlRepresentation = xmlRepresentation;
    }

    public JaxbRepresentation(T object) {
        this(MediaType.APPLICATION_XML, object);
    }

    public Object evaluate(String expression, QName returnType) throws Exception {
        Object result = null;
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext((NamespaceContext)((Object)this));
        Document xmlDocument = this.getDocumentBuilder().parse(this.xmlRepresentation.getStream());
        if (xmlDocument == null) {
            throw new Exception("Unable to obtain a DOM document for the XML representation. XPath evaluation cancelled.");
        }
        result = xpath.evaluate(expression, xmlDocument, returnType);
        return result;
    }

    private JAXBContext getContext() throws JAXBException {
        return JaxbRepresentation.getContext(this.getContextPath());
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public T getObject() throws IOException {
        if (this.object == null && this.xmlRepresentation != null) {
            Unmarshaller u = new Unmarshaller(this.contextPath);
            if (this.getValidationEventHandler() != null) {
                try {
                    u.setEventHandler(this.getValidationEventHandler());
                }
                catch (JAXBException e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Unable to set the event handler", e);
                    throw new IOException("Unable to set the event handler." + e.getMessage());
                }
            }
            try {
                this.object = u.unmarshal(this.xmlRepresentation.getStream());
            }
            catch (JAXBException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to unmarshal the XML representation", e);
                throw new IOException("Unable to unmarshal the XML representation." + e.getMessage());
            }
        }
        return this.object;
    }

    public SAXSource getSaxSource() throws IOException {
        try {
            return new JAXBSource(this.getContext(), this.getObject());
        }
        catch (JAXBException e) {
            throw new IOException("JAXBException while creating the JAXBSource: " + e.getMessage());
        }
    }

    public ValidationEventHandler getValidationEventHandler() {
        return this.validationEventHandler;
    }

    public boolean isFormattedOutput() {
        return this.formattedOutput;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setFormattedOutput(boolean formattedOutput) {
        this.formattedOutput = formattedOutput;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public void write(OutputStream outputStream) throws IOException {
        try {
            new Marshaller(this.contextPath).marshal(this.getObject(), outputStream);
        }
        catch (JAXBException e) {
            Context.getCurrentLogger().log(Level.WARNING, "JAXB marshalling error caught.", e);
            try {
                new Marshaller("failure").marshal(this.getObject(), outputStream);
            }
            catch (JAXBException e2) {
                throw new IOException(e.getMessage());
            }
        }
    }

    private class Unmarshaller {
        private final String pkg;
        private final ThreadLocal<javax.xml.bind.Unmarshaller> unmarshaller = new ThreadLocal<javax.xml.bind.Unmarshaller>(){

            @Override
            protected synchronized javax.xml.bind.Unmarshaller initialValue() {
                javax.xml.bind.Unmarshaller m = null;
                try {
                    m = JaxbRepresentation.getContext(Unmarshaller.this.getPackage()).createUnmarshaller();
                }
                catch (Exception e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Problem creating Unmarshaller", e);
                    return null;
                }
                return m;
            }
        };

        Unmarshaller(String pkg) {
            this.pkg = pkg;
        }

        String getPackage() {
            return this.pkg;
        }

        private javax.xml.bind.Unmarshaller getUnmarshaller() throws JAXBException {
            javax.xml.bind.Unmarshaller m = this.unmarshaller.get();
            if (m == null) {
                Context.getCurrentLogger().warning("Unable to locate unmarshaller.");
                throw new JAXBException("Unable to locate unmarshaller.");
            }
            return m;
        }

        public void setEventHandler(ValidationEventHandler handler) throws JAXBException {
            this.getUnmarshaller().setEventHandler(handler);
        }

        public Object unmarshal(InputStream stream) throws JAXBException {
            return this.getUnmarshaller().unmarshal(stream);
        }

        public Object unmarshal(Reader reader) throws JAXBException {
            return this.getUnmarshaller().unmarshal(reader);
        }

        public Object unmarshal(StringRepresentation rep) throws JAXBException, IOException {
            return this.getUnmarshaller().unmarshal(rep.getStream());
        }
    }

    private class Marshaller {
        private final ThreadLocal<javax.xml.bind.Marshaller> marshaller = new ThreadLocal<javax.xml.bind.Marshaller>(){

            @Override
            protected synchronized javax.xml.bind.Marshaller initialValue() {
                javax.xml.bind.Marshaller m = null;
                try {
                    m = JaxbRepresentation.getContext(Marshaller.this.getPackage()).createMarshaller();
                    m.setProperty("jaxb.formatted.output", (Object)JaxbRepresentation.this.isFormattedOutput());
                    if (JaxbRepresentation.this.getCharacterSet() != null) {
                        m.setProperty("jaxb.encoding", (Object)JaxbRepresentation.this.getCharacterSet().getName());
                    }
                }
                catch (Exception e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Problem creating Marshaller", e);
                    return null;
                }
                return m;
            }
        };
        private final String pkg;

        private Marshaller() {
            this(null);
        }

        private Marshaller(String pkg) {
            this.pkg = pkg;
        }

        private javax.xml.bind.Marshaller getMarshaller() throws JAXBException {
            javax.xml.bind.Marshaller m = this.marshaller.get();
            if (m == null) {
                Context.getCurrentLogger().warning("Unable to locate marshaller.");
                throw new JAXBException("Unable to locate marshaller.");
            }
            return m;
        }

        String getPackage() {
            return this.pkg;
        }

        public void marshal(Object jaxbElement, OutputStream stream) throws JAXBException {
            this.getMarshaller().marshal(jaxbElement, stream);
        }

        public void marshal(Object jaxbElement, StringRepresentation rep) throws JAXBException {
            StringWriter writer = new StringWriter();
            this.marshal(jaxbElement, writer);
            rep.setText(writer.toString());
        }

        public void marshal(Object jaxbElement, Writer writer) throws JAXBException {
            this.getMarshaller().marshal(jaxbElement, writer);
        }

        public void setEventHandler(ValidationEventHandler handler) throws JAXBException {
            this.getMarshaller().setEventHandler(handler);
        }
    }
}

