/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Guard;
import org.restlet.Restlet;
import org.restlet.Route;
import org.restlet.ext.jaxrs.JaxRsRestlet;
import org.restlet.ext.jaxrs.ObjectFactory;
import org.restlet.ext.jaxrs.RoleChecker;
import org.restlet.ext.jaxrs.internal.todo.NotYetImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxRsApplication
extends Application {
    private volatile boolean appConfigAttached = false;
    private volatile Guard guard;
    private volatile JaxRsRestlet jaxRsRestlet;

    public JaxRsApplication() {
        this(null);
    }

    public JaxRsApplication(Context context) {
        super(context);
        this.getTunnelService().setExtensionsTunnel(false);
        this.jaxRsRestlet = new JaxRsRestlet(context, this.getMetadataService());
    }

    public boolean add(javax.ws.rs.core.Application appConfig) throws IllegalArgumentException {
        return this.add(appConfig, true);
    }

    public boolean add(javax.ws.rs.core.Application appConfig, boolean clearMetadataIfFirst) throws IllegalArgumentException {
        if (appConfig == null) {
            throw new IllegalArgumentException("The ApplicationConfig must not be null");
        }
        if (clearMetadataIfFirst && !this.appConfigAttached) {
            this.getMetadataService().clearExtensions();
        }
        JaxRsRestlet jaxRsRestlet = this.jaxRsRestlet;
        Set classes = appConfig.getClasses();
        Set singletons = appConfig.getSingletons();
        boolean everythingFine = true;
        if (singletons != null) {
            for (Object singleton : singletons) {
                if (singleton == null || classes.contains(singleton.getClass())) continue;
                everythingFine &= jaxRsRestlet.addSingleton(singleton);
            }
        }
        if (classes != null) {
            for (Class clazz : classes) {
                everythingFine &= jaxRsRestlet.addClass(clazz);
            }
        }
        this.appConfigAttached = true;
        return everythingFine;
    }

    public Restlet createRoot() {
        JaxRsRestlet restlet = this.jaxRsRestlet;
        if (this.guard != null) {
            this.guard.setNext((Restlet)restlet);
            restlet = this.guard;
        }
        return restlet;
    }

    public Guard getGuard() {
        return this.guard;
    }

    public ObjectFactory getObjectFactory() {
        return this.jaxRsRestlet.getObjectFactory();
    }

    public RoleChecker getRoleChecker() {
        return this.jaxRsRestlet.getRoleChecker();
    }

    public Collection<Class<?>> getRootResources() {
        return this.jaxRsRestlet.getRootResourceClasses();
    }

    public Collection<String> getRootUris() {
        return this.jaxRsRestlet.getRootUris();
    }

    @Deprecated
    private List<Route> getRoutes() {
        throw new NotYetImplementedException();
    }

    public void setAuthentication(Guard guard, RoleChecker roleChecker) {
        this.setGuard(guard);
        this.setRoleChecker(roleChecker);
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.jaxRsRestlet.setContext(context);
    }

    public void setGuard(Guard guard) {
        this.guard = guard;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.jaxRsRestlet.setObjectFactory(objectFactory);
    }

    public void setRoleChecker(RoleChecker roleChecker) {
        this.jaxRsRestlet.setRoleChecker(roleChecker);
    }
}

