/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.restlet.data.CharacterSet;
import org.restlet.data.Response;
import org.restlet.ext.jaxrs.internal.provider.AbstractProvider;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.resource.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"*/*"})
@Consumes(value={"*/*"})
public class StringProvider
extends AbstractProvider<CharSequence> {
    private byte[] getByteArray(CharSequence entity, String charsetName) {
        String string = ((Object)entity).toString();
        try {
            if (charsetName != null) {
                return string.getBytes(charsetName);
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        try {
            return string.getBytes(Util.JAX_RS_DEFAULT_CHARACTER_SET_AS_STRING);
        }
        catch (UnsupportedEncodingException e1) {
            return string.getBytes();
        }
    }

    private String getCurrentEntityCharset() {
        Representation entity = Response.getCurrent().getEntity();
        if (entity == null) {
            return null;
        }
        CharacterSet characterSet = entity.getCharacterSet();
        if (characterSet == null) {
            return null;
        }
        return characterSet.toString();
    }

    private ByteArrayInputStream getInputStream(CharSequence charSequ, String charsetName) {
        byte[] bytes = this.getByteArray(charSequ, charsetName);
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public long getSize(CharSequence entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.getByteArray(entity, this.getCurrentEntityCharset()).length;
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isAssignableFrom(String.class);
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return CharSequence.class.isAssignableFrom(type);
    }

    @Override
    public String readFrom(Class<CharSequence> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        return Util.copyToStringBuilder(entityStream).toString();
    }

    @Override
    public void writeTo(CharSequence charSequence, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        String charset = this.getCurrentEntityCharset();
        ByteArrayInputStream inputStream = this.getInputStream(charSequence, charset);
        Util.copyStream(inputStream, entityStream);
    }
}

