/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.spring;

import java.util.ArrayList;
import java.util.List;
import org.restlet.Context;
import org.restlet.ext.spring.SpringResource;
import org.restlet.resource.Representation;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.PropertiesBeanDefinitionReader;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringContext
extends GenericApplicationContext {
    private Context restletContext;
    private List<String> propertyConfigRefs;
    private List<String> xmlConfigRefs;
    private boolean loaded;

    public SpringContext(Context restletContext) {
        this.restletContext = restletContext;
        this.propertyConfigRefs = null;
        this.xmlConfigRefs = null;
        this.loaded = false;
    }

    public Context getRestletContext() {
        return this.restletContext;
    }

    public List<String> getPropertyConfigRefs() {
        if (this.propertyConfigRefs == null) {
            this.propertyConfigRefs = new ArrayList<String>();
        }
        return this.propertyConfigRefs;
    }

    public List<String> getXmlConfigRefs() {
        if (this.xmlConfigRefs == null) {
            this.xmlConfigRefs = new ArrayList<String>();
        }
        return this.xmlConfigRefs;
    }

    public void refresh() {
        if (!this.loaded) {
            Representation config = null;
            PropertiesBeanDefinitionReader propReader = null;
            for (String ref : this.getPropertyConfigRefs()) {
                config = this.getRestletContext().getDispatcher().get(ref).getEntity();
                if (config == null) continue;
                propReader = new PropertiesBeanDefinitionReader((BeanDefinitionRegistry)this);
                propReader.loadBeanDefinitions((Resource)new SpringResource(config));
            }
            XmlBeanDefinitionReader xmlReader = null;
            for (String ref : this.getXmlConfigRefs()) {
                config = this.getRestletContext().getDispatcher().get(ref).getEntity();
                if (config == null) continue;
                xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this);
                xmlReader.setValidationMode(3);
                xmlReader.loadBeanDefinitions((Resource)new SpringResource(config));
            }
        }
        super.refresh();
    }
}

