/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.velocity;

import java.io.IOException;
import java.util.Map;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.restlet.Context;
import org.restlet.Filter;
import org.restlet.Restlet;
import org.restlet.data.Encoding;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.ext.velocity.TemplateRepresentation;
import org.restlet.resource.Representation;
import org.restlet.util.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateFilter
extends Filter {
    private volatile Map<String, Object> mapDataModel;
    private volatile Resolver<Object> resolverDataModel;

    public TemplateFilter() {
    }

    public TemplateFilter(Context context) {
        super(context);
    }

    public TemplateFilter(Context context, Restlet next) {
        super(context, next);
        this.mapDataModel = null;
        this.resolverDataModel = null;
    }

    public TemplateFilter(Context context, Restlet next, Map<String, Object> dataModel) {
        super(context, next);
        this.mapDataModel = dataModel;
        this.resolverDataModel = null;
    }

    public TemplateFilter(Context context, Restlet next, Resolver<Object> dataModel) {
        super(context, next);
        this.mapDataModel = null;
        this.resolverDataModel = dataModel;
    }

    protected void afterHandle(Request request, Response response) {
        if (response.isEntityAvailable() && response.getEntity().getEncodings().contains(Encoding.VELOCITY)) {
            try {
                TemplateRepresentation representation = new TemplateRepresentation(response.getEntity(), response.getEntity().getMediaType());
                if (this.mapDataModel == null && this.resolverDataModel == null) {
                    representation.setDataModel(request, response);
                } else if (this.mapDataModel == null) {
                    representation.setDataModel(this.resolverDataModel);
                } else {
                    representation.setDataModel(this.mapDataModel);
                }
                response.setEntity((Representation)representation);
            }
            catch (ResourceNotFoundException e) {
                response.setStatus(Status.CLIENT_ERROR_NOT_FOUND, (Throwable)e);
            }
            catch (ParseErrorException e) {
                response.setStatus(Status.SERVER_ERROR_INTERNAL, (Throwable)e);
            }
            catch (IOException e) {
                response.setStatus(Status.SERVER_ERROR_INTERNAL, (Throwable)e);
            }
        }
    }
}

