/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.io.IOException;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.resource.DomRepresentation;
import org.restlet.util.XmlWriter;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DocumentationInfo {
    private Language language;
    private Node mixedContent;
    private String title;

    public DocumentationInfo() {
    }

    public DocumentationInfo(String textContent) {
        this.setTextContent(textContent);
    }

    public DocumentationInfo(Node mixedContent) {
        this.mixedContent = mixedContent;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Node getMixedContent() {
        return this.mixedContent;
    }

    public String getTextContent() {
        return this.mixedContent.getTextContent();
    }

    public String getTitle() {
        return this.title;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public void setMixedContent(Node mixedContent) {
        this.mixedContent = mixedContent;
    }

    public void setTextContent(String textContent) {
        try {
            Document doc = new DomRepresentation(MediaType.TEXT_XML).getDocument();
            this.mixedContent = doc.createTextNode(textContent);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        if (this.getTitle() != null && !this.getTitle().equals("")) {
            attributes.addAttribute("", "title", null, "xs:string", this.getTitle());
        }
        if (this.getLanguage() != null && this.getLanguage().toString() != null) {
            attributes.addAttribute("", "xml:lang", null, "xs:string", this.getLanguage().toString());
        }
        if (this.getMixedContent() == null) {
            writer.emptyElement("http://research.sun.com/wadl/2006/10", "doc", null, (Attributes)attributes);
        } else {
            writer.startElement("http://research.sun.com/wadl/2006/10", "doc", null, (Attributes)attributes);
            try {
                boolean isDataFormat = writer.isDataFormat();
                writer.setDataFormat(false);
                this.writeElement(writer, this.getMixedContent());
                writer.setDataFormat(isDataFormat);
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.SEVERE, "Error when writing the text content of the current \"doc\" tag.", e);
            }
            writer.endElement("http://research.sun.com/wadl/2006/10", "doc");
        }
    }

    private void writeElement(XmlWriter writer, Node node) throws IOException, SAXException {
        if (node instanceof CDATASection) {
            CDATASection section = (CDATASection)node;
            writer.getWriter().write("<![CDATA[");
            writer.getWriter().write(section.getData());
            writer.getWriter().write("]]>");
        } else if (node instanceof Text) {
            Text text = (Text)node;
            writer.getWriter().write(text.getNodeValue());
        } else if (node instanceof EntityReference) {
            EntityReference entity = (EntityReference)node;
            writer.getWriter().write("&");
            writer.getWriter().write(entity.getNodeName());
            writer.getWriter().write(";");
        } else if (node instanceof Comment) {
            Comment comment = (Comment)node;
            writer.getWriter().write("<!-- ");
            writer.getWriter().write(comment.getData());
            writer.getWriter().write(" -->");
        } else if (node instanceof DocumentFragment) {
            DocumentFragment documentFragment = (DocumentFragment)node;
            for (int i = 0; i < documentFragment.getChildNodes().getLength(); ++i) {
                this.writeElement(writer, documentFragment.getChildNodes().item(i));
            }
        } else {
            int i;
            AttributesImpl attributes = null;
            if (node.hasAttributes()) {
                attributes = new AttributesImpl();
                for (i = 0; i < node.getAttributes().getLength(); ++i) {
                    Node attribute = node.getAttributes().item(i);
                    attributes.addAttribute(attribute.getNamespaceURI(), attribute.getLocalName(), "", null, attribute.getNodeValue());
                }
            }
            if (node.getChildNodes() != null && node.getChildNodes().getLength() > 0) {
                if (attributes == null) {
                    writer.startElement(node.getNamespaceURI(), node.getLocalName());
                } else {
                    writer.startElement(node.getNamespaceURI(), node.getLocalName(), node.getPrefix(), (Attributes)attributes);
                }
                for (i = 0; i < node.getChildNodes().getLength(); ++i) {
                    this.writeElement(writer, node.getChildNodes().item(i));
                }
                writer.endElement(node.getNamespaceURI(), node.getLocalName());
            } else if (attributes == null) {
                writer.emptyElement(node.getNamespaceURI(), node.getLocalName());
            } else {
                writer.emptyElement(node.getNamespaceURI(), node.getLocalName(), node.getPrefix(), (Attributes)attributes);
            }
        }
    }
}

