/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.util.Iterator;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.wadl.DocumentationInfo;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.RepresentationInfo;
import org.restlet.util.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultInfo
extends RepresentationInfo {
    public FaultInfo(Status status) {
        this.getStatuses().add(status);
    }

    public FaultInfo(Status status, DocumentationInfo documentation) {
        super(documentation);
        this.getStatuses().add(status);
    }

    public FaultInfo(Status status, List<DocumentationInfo> documentations) {
        super(documentations);
        this.getStatuses().add(status);
    }

    public FaultInfo(Status status, String documentation) {
        this(status, new DocumentationInfo(documentation));
    }

    public FaultInfo(Status status, MediaType mediaType, String documentation) {
        this(status, new DocumentationInfo(documentation));
        this.setMediaType(mediaType);
    }

    @Override
    public void writeElement(XmlWriter writer) throws SAXException {
        Iterator<Reference> iterator;
        StringBuilder builder;
        AttributesImpl attributes = new AttributesImpl();
        if (this.getIdentifier() != null && !this.getIdentifier().equals("")) {
            attributes.addAttribute("", "id", null, "xs:ID", this.getIdentifier());
        }
        if (this.getMediaType() != null) {
            attributes.addAttribute("", "mediaType", null, "xs:string", this.getMediaType().toString());
        }
        if (this.getProfiles() != null && !this.getProfiles().isEmpty()) {
            builder = new StringBuilder();
            iterator = this.getProfiles().iterator();
            while (iterator.hasNext()) {
                Reference reference = iterator.next();
                builder.append(reference.toString());
                if (!iterator.hasNext()) continue;
                builder.append(" ");
            }
            attributes.addAttribute("", "profile", null, "xs:string", builder.toString());
        }
        if (this.getStatuses() != null && !this.getStatuses().isEmpty()) {
            builder = new StringBuilder();
            iterator = this.getStatuses().iterator();
            while (iterator.hasNext()) {
                Status status = (Status)iterator.next();
                builder.append(status.getCode());
                if (!iterator.hasNext()) continue;
                builder.append(" ");
            }
            attributes.addAttribute("", "status", null, "xs:string", builder.toString());
        }
        if (this.getXmlElement() != null && !this.getXmlElement().equals("")) {
            attributes.addAttribute("", "element", null, "xs:QName", this.getXmlElement());
        }
        if (this.getDocumentations().isEmpty() && this.getParameters().isEmpty()) {
            writer.emptyElement("http://research.sun.com/wadl/2006/10", "fault", null, (Attributes)attributes);
        } else {
            writer.startElement("http://research.sun.com/wadl/2006/10", "fault", null, (Attributes)attributes);
            for (DocumentationInfo documentationInfo : this.getDocumentations()) {
                documentationInfo.writeElement(writer);
            }
            for (ParameterInfo parameterInfo : this.getParameters()) {
                parameterInfo.writeElement(writer);
            }
            writer.endElement("http://research.sun.com/wadl/2006/10", "fault");
        }
    }
}

