/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Directory;
import org.restlet.Filter;
import org.restlet.Finder;
import org.restlet.Handler;
import org.restlet.Restlet;
import org.restlet.Route;
import org.restlet.Router;
import org.restlet.Server;
import org.restlet.VirtualHost;
import org.restlet.data.ClientInfo;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.ext.wadl.ApplicationInfo;
import org.restlet.ext.wadl.MethodInfo;
import org.restlet.ext.wadl.RepresentationInfo;
import org.restlet.ext.wadl.ResourceInfo;
import org.restlet.ext.wadl.ResponseInfo;
import org.restlet.ext.wadl.WadlDescribable;
import org.restlet.ext.wadl.WadlRepresentation;
import org.restlet.ext.wadl.WadlResource;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;
import org.restlet.resource.Variant;
import org.restlet.util.Engine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WadlApplication
extends Application {
    private volatile boolean autoDescribed;
    private volatile Reference baseRef;
    private volatile Router router;

    public WadlApplication() {
        this((Context)null);
    }

    public WadlApplication(Context context) {
        super(context);
        this.autoDescribed = true;
    }

    public WadlApplication(Context context, Representation wadl) {
        super(context);
        this.autoDescribed = false;
        try {
            Router root;
            WadlRepresentation wadlRep = null;
            wadlRep = wadl instanceof WadlRepresentation ? (WadlRepresentation)wadl : new WadlRepresentation(wadl);
            this.router = root = new Router(this.getContext());
            this.setRoot((Restlet)root);
            if (wadlRep.getApplication() != null && wadlRep.getApplication().getResources() != null) {
                for (ResourceInfo resource : wadlRep.getApplication().getResources().getResources()) {
                    this.attachResource(resource, null, this.router);
                }
                this.setBaseRef(wadlRep.getApplication().getResources().getBaseRef());
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Error during the attachment of the WADL application", e);
        }
    }

    public WadlApplication(Representation wadl) {
        this(null, wadl);
    }

    private void addConnectors(Component component) {
        Protocol protocol = this.getBaseRef().getSchemeProtocol();
        int port = this.getBaseRef().getHostPort();
        boolean exists = false;
        if (port == -1) {
            for (Server server : component.getServers()) {
                if (!server.getProtocols().contains(protocol) || server.getPort() != protocol.getDefaultPort()) continue;
                exists = true;
            }
            if (!exists) {
                component.getServers().add(protocol);
            }
        } else {
            for (Server server : component.getServers()) {
                if (!server.getProtocols().contains(protocol) || server.getPort() != port) continue;
                exists = true;
            }
            if (!exists) {
                component.getServers().add(protocol, port);
            }
        }
    }

    private void attachResource(ResourceInfo currentResource, ResourceInfo parentResource, Router router) throws ClassNotFoundException {
        String uriPattern = currentResource.getPath();
        if (parentResource != null) {
            String parentUriPattern = parentResource.getPath();
            if (!parentUriPattern.endsWith("/") && !uriPattern.startsWith("/")) {
                parentUriPattern = parentUriPattern + "/";
            }
            uriPattern = parentUriPattern + uriPattern;
            currentResource.setPath(uriPattern);
        } else if (!uriPattern.startsWith("/")) {
            uriPattern = "/" + uriPattern;
            currentResource.setPath(uriPattern);
        }
        if (currentResource.getIdentifier() != null) {
            Class targetClass = Engine.loadClass((String)currentResource.getIdentifier());
            router.attach(uriPattern, targetClass);
        } else {
            this.getLogger().fine("Unable to find the 'id' attribute of the resource element with this path attribute \"" + uriPattern + "\"");
        }
        for (ResourceInfo childResource : currentResource.getChildResources()) {
            this.attachResource(childResource, currentResource, router);
        }
    }

    public VirtualHost attachToComponent(Component component) {
        VirtualHost result = null;
        if (this.getBaseRef() != null) {
            result = this.getVirtualHost(component);
            this.attachToHost(result);
            this.addConnectors(component);
        } else {
            this.getLogger().warning("The WADL application has no base reference defined. Unable to guess the virtual host.");
        }
        return result;
    }

    public void attachToHost(VirtualHost host) {
        if (this.getBaseRef() != null) {
            String path = this.getBaseRef().getPath();
            if (path == null) {
                host.attach("", (Restlet)this);
            } else {
                host.attach(path, (Restlet)this);
            }
        } else {
            this.getLogger().warning("The WADL application has no base reference defined. Unable to guess the virtual host.");
        }
    }

    public ApplicationInfo getApplicationInfo(Request request, Response response) {
        ApplicationInfo applicationInfo = new ApplicationInfo();
        applicationInfo.getResources().setBaseRef(request.getResourceRef().getBaseRef());
        applicationInfo.getResources().setResources(this.getResourceInfos(this.getFirstRouter(this.getRoot()), request, response));
        return applicationInfo;
    }

    public Reference getBaseRef() {
        return this.baseRef;
    }

    private Router getFirstRouter(Restlet current) {
        Router result = this.getRouter();
        if (result == null) {
            if (current instanceof Router) {
                result = (Router)current;
            } else if (current instanceof Filter) {
                result = this.getFirstRouter(((Filter)current).getNext());
            }
        }
        return result;
    }

    protected Variant getPreferredWadlVariant(ClientInfo clientInfo) {
        Variant result = null;
        Application app = Application.getCurrent();
        Language language = null;
        if (app != null) {
            language = app.getMetadataService().getDefaultLanguage();
        }
        result = clientInfo.getPreferredVariant(this.getWadlVariants(), language);
        return result;
    }

    private ResourceInfo getResourceInfo(Filter filter, String path, Request request, Response response) {
        return this.getResourceInfo(filter.getNext(), path, request, response);
    }

    private ResourceInfo getResourceInfo(Finder finder, String path, Request request, Response response) {
        ResourceInfo result = null;
        Application.setCurrent((Application)this);
        Handler handler = finder.createTarget(finder.getTargetClass(), request, response);
        if (handler instanceof WadlResource) {
            WadlResource resource = (WadlResource)handler;
            result = new ResourceInfo();
            resource.describe(path, result);
        } else {
            result = new ResourceInfo();
            result.setPath(path);
            ArrayList<Method> methods = new ArrayList<Method>();
            if (handler != null) {
                methods.addAll(handler.getAllowedMethods());
            } else if (finder instanceof Directory) {
                Directory directory = (Directory)finder;
                methods.add(Method.GET);
                if (directory.isModifiable()) {
                    methods.add(Method.DELETE);
                    methods.add(Method.PUT);
                }
            }
            Collections.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method m1, Method m2) {
                    return m1.getName().compareTo(m2.getName());
                }
            });
            if (handler instanceof Resource) {
                Resource resource = (Resource)handler;
                for (Method method : methods) {
                    MethodInfo methodInfo = new MethodInfo();
                    methodInfo.setName(method);
                    if (Method.GET.equals((Object)method)) {
                        ResponseInfo responseInfo = new ResponseInfo();
                        for (Variant variant : resource.getVariants()) {
                            RepresentationInfo representationInfo = new RepresentationInfo();
                            representationInfo.setMediaType(variant.getMediaType());
                            responseInfo.getRepresentations().add(representationInfo);
                        }
                        methodInfo.setResponse(responseInfo);
                    }
                    result.getMethods().add(methodInfo);
                }
            } else {
                for (Method method : methods) {
                    MethodInfo methodInfo = new MethodInfo();
                    methodInfo.setName(method);
                    result.getMethods().add(methodInfo);
                }
            }
        }
        return result;
    }

    private ResourceInfo getResourceInfo(Restlet restlet, String path, Request request, Response response) {
        ResourceInfo result = null;
        if (restlet instanceof WadlDescribable) {
            result = ((WadlDescribable)restlet).getResourceInfo();
            result.setPath(path);
        } else if (restlet instanceof Finder) {
            result = this.getResourceInfo((Finder)restlet, path, request, response);
        } else if (restlet instanceof Router) {
            result = new ResourceInfo();
            result.setPath(path);
            result.setChildResources(this.getResourceInfos((Router)restlet, request, response));
        } else if (restlet instanceof Filter) {
            result = this.getResourceInfo((Filter)restlet, path, request, response);
        }
        return result;
    }

    private ResourceInfo getResourceInfo(Route route, String basePath, Request request, Response response) {
        String path = route.getTemplate().getPattern();
        if (path.startsWith("/") && basePath.endsWith("/")) {
            path = path.substring(1);
        }
        ResourceInfo result = this.getResourceInfo(route.getNext(), path, request, response);
        return result;
    }

    private List<ResourceInfo> getResourceInfos(Router router, Request request, Response response) {
        ArrayList<ResourceInfo> result = new ArrayList<ResourceInfo>();
        for (Route route : router.getRoutes()) {
            ResourceInfo resourceInfo = this.getResourceInfo(route, "/", request, response);
            if (resourceInfo == null) continue;
            result.add(resourceInfo);
        }
        return result;
    }

    public Router getRouter() {
        return this.router;
    }

    private VirtualHost getVirtualHost(Component component) {
        String hostDomain = this.baseRef.getHostDomain();
        String hostPort = Integer.toString(this.baseRef.getHostPort());
        String hostScheme = this.baseRef.getScheme();
        VirtualHost host = null;
        for (VirtualHost vh : component.getHosts()) {
            if (!vh.getHostDomain().equals(hostDomain) || !vh.getHostPort().equals(hostPort) || !vh.getHostScheme().equals(hostScheme)) continue;
            host = vh;
        }
        if (host == null) {
            host = new VirtualHost(component.getContext().createChildContext());
            host.setHostDomain(hostDomain);
            host.setHostPort(hostPort);
            host.setHostScheme(hostScheme);
            component.getHosts().add(host);
        }
        return host;
    }

    protected List<Variant> getWadlVariants() {
        ArrayList<Variant> result = new ArrayList<Variant>();
        result.add(new Variant(MediaType.APPLICATION_WADL_XML));
        result.add(new Variant(MediaType.TEXT_HTML));
        return result;
    }

    public void handle(Request request, Response response) {
        super.handle(request, response);
        Reference rr = request.getResourceRef();
        String rp = rr.getRemainingPart(false, false);
        if (this.isAutoDescribed() && Method.OPTIONS.equals((Object)request.getMethod()) && (Status.CLIENT_ERROR_NOT_FOUND.equals((Object)response.getStatus()) || !response.isEntityAvailable()) && ("/".equals(rp) || "".equals(rp))) {
            if (!rr.getBaseRef().getIdentifier().endsWith("/")) {
                rr.setBaseRef(rr.getBaseRef() + "/");
            }
            response.setEntity(this.wadlRepresent(request, response));
            if (response.isEntityAvailable()) {
                response.setStatus(Status.SUCCESS_OK);
            }
        }
    }

    public boolean isAutoDescribed() {
        return this.autoDescribed;
    }

    public void setAutoDescribed(boolean autoDescribed) {
        this.autoDescribed = autoDescribed;
    }

    public void setBaseRef(Reference baseRef) {
        this.baseRef = baseRef;
    }

    protected Representation wadlRepresent(Request request, Response response) {
        return this.wadlRepresent(this.getPreferredWadlVariant(request.getClientInfo()), request, response);
    }

    public Representation wadlRepresent(Variant variant, Request request, Response response) {
        WadlRepresentation result = null;
        if (variant != null) {
            if (MediaType.APPLICATION_WADL_XML.equals((Object)variant.getMediaType())) {
                result = new WadlRepresentation(this.getApplicationInfo(request, response));
            } else if (MediaType.TEXT_HTML.equals((Object)variant.getMediaType())) {
                result = new WadlRepresentation(this.getApplicationInfo(request, response)).getHtmlRepresentation();
            }
        }
        return result;
    }
}

