/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Finder;
import org.restlet.data.LocalReference;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.ReferenceList;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;
import org.restlet.resource.Variant;
import org.restlet.util.Engine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Directory
extends Finder {
    private boolean negotiateContent;
    private boolean deeplyAccessible;
    private String indexName;
    private Reference rootRef;
    private boolean modifiable;
    private boolean listingAllowed;

    public Directory(Context context, LocalReference rootLocalReference) {
        super(context);
        String rootIdentifier = rootLocalReference.getTargetRef().getIdentifier();
        this.rootRef = rootIdentifier.endsWith("/") ? new Reference(rootIdentifier) : new Reference(rootIdentifier + "/");
        this.deeplyAccessible = true;
        this.indexName = "index";
        this.listingAllowed = false;
        this.modifiable = false;
        this.negotiateContent = true;
    }

    public Directory(Context context, String rootUri) {
        this(context, new LocalReference(rootUri));
    }

    @Override
    public Resource findTarget(Request request, Response response) {
        try {
            return Engine.getInstance().createDirectoryResource(this, request, response);
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, "Unable to find the directory's resource", ioe);
            return null;
        }
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Representation getIndexRepresentation(Variant variant, ReferenceList indexContent) {
        Representation result = null;
        if (variant.getMediaType().equals(MediaType.TEXT_HTML)) {
            result = indexContent.getWebRepresentation();
        } else if (variant.getMediaType().equals(MediaType.TEXT_URI_LIST)) {
            result = indexContent.getTextRepresentation();
        }
        return result;
    }

    public List<Variant> getIndexVariants(ReferenceList indexContent) {
        ArrayList<Variant> result = new ArrayList<Variant>();
        result.add(new Variant(MediaType.TEXT_HTML));
        result.add(new Variant(MediaType.TEXT_URI_LIST));
        return result;
    }

    public Reference getRootRef() {
        return this.rootRef;
    }

    public boolean isDeeplyAccessible() {
        return this.deeplyAccessible;
    }

    public boolean isListingAllowed() {
        return this.listingAllowed;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public boolean isNegotiateContent() {
        return this.negotiateContent;
    }

    public void setDeeplyAccessible(boolean deeplyAccessible) {
        this.deeplyAccessible = deeplyAccessible;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setListingAllowed(boolean listingAllowed) {
        this.listingAllowed = listingAllowed;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    public void setNegotiateContent(boolean negotiateContent) {
        this.negotiateContent = negotiateContent;
    }
}

