/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.ArrayList;
import java.util.List;
import org.restlet.data.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Language
extends Metadata {
    public static final Language ALL = new Language("*", "All languages");
    public static final Language ENGLISH = new Language("en", "English language");
    public static final Language ENGLISH_US = new Language("en-us", "English language in USA");
    public static final Language FRENCH = new Language("fr", "French language");
    public static final Language FRENCH_FRANCE = new Language("fr-fr", "French language in France");
    public static final Language SPANISH = new Language("es", "Spanish language");
    private List<String> subTags = null;

    public static Language valueOf(String name) {
        Language result = null;
        if (name != null) {
            result = name.equalsIgnoreCase(ALL.getName()) ? ALL : (name.equalsIgnoreCase(ENGLISH.getName()) ? ENGLISH : (name.equalsIgnoreCase(ENGLISH_US.getName()) ? ENGLISH_US : (name.equalsIgnoreCase(FRENCH.getName()) ? FRENCH : (name.equalsIgnoreCase(FRENCH_FRANCE.getName()) ? FRENCH_FRANCE : (name.equalsIgnoreCase(SPANISH.getName()) ? SPANISH : new Language(name))))));
        }
        return result;
    }

    public Language(String name) {
        this(name, "Language or range of languages");
    }

    public Language(String name, String description) {
        super(name, description);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Language && this.getName().equalsIgnoreCase(((Language)object).getName());
    }

    public String getPrimaryTag() {
        int separator = this.getName().indexOf(45);
        if (separator == -1) {
            return this.getName();
        }
        return this.getName().substring(0, separator);
    }

    public List<String> getSubTags() {
        if (this.subTags == null) {
            String[] tags = this.getName().split("-");
            this.subTags = new ArrayList<String>();
            if (tags.length > 0) {
                for (int i = 1; i < tags.length; ++i) {
                    this.subTags.add(tags[i]);
                }
            }
        }
        return this.subTags;
    }

    @Override
    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().toLowerCase().hashCode();
    }
}

