/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Directory;
import org.restlet.Server;
import org.restlet.data.CharacterSet;
import org.restlet.data.ClientInfo;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;
import org.restlet.resource.Variant;
import org.restlet.util.Helper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Engine {
    private static Logger logger = Logger.getLogger(Engine.class.getCanonicalName());
    public static final String MAJOR_NUMBER = "1";
    public static final String MINOR_NUMBER = "0";
    public static final String RELEASE_NUMBER = ".11";
    public static final String VERSION = "1.0..11";
    private static Engine instance = null;
    private static final String providerResource = "META-INF/services/org.restlet.util.Engine";
    private static ClassLoader classloader = Engine.class.getClassLoader();

    public static ClassLoader getClassLoader() {
        return classloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Engine getInstance() {
        Engine result = instance;
        if (result == null) {
            String engineClassName = null;
            ClassLoader cl = Engine.getClassLoader();
            URL configURL = cl.getResource(providerResource);
            if (configURL == null) {
                cl = Thread.currentThread().getContextClassLoader();
                configURL = cl.getResource(providerResource);
            }
            if (configURL == null) {
                cl = ClassLoader.getSystemClassLoader();
                configURL = cl.getResource(providerResource);
            }
            if (configURL != null) {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(configURL.openStream(), "utf-8"));
                    String providerName = reader.readLine();
                    if (providerName != null) {
                        engineClassName = providerName.substring(0, providerName.indexOf(35)).trim();
                    }
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Unable to register the Restlet API implementation. Please check that the JAR file is in your classpath.");
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            logger.warning("IOException encountered while closing an open BufferedReader" + e.getMessage());
                        }
                    }
                }
                try {
                    result = instance = (Engine)Class.forName(engineClassName).newInstance();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unable to register the Restlet API implementation", e);
                    throw new RuntimeException("Unable to register the Restlet API implementation");
                }
            }
            if (configURL == null) {
                logger.log(Level.SEVERE, "Unable to find an implementation of the Restlet API. Please check your classpath.");
            }
        }
        return result;
    }

    public static int hashCode(Object ... objects) {
        int result = 1;
        if (objects != null) {
            for (Object obj : objects) {
                result = 31 * result + (obj == null ? 0 : obj.hashCode());
            }
        }
        return result;
    }

    public static void setClassLoader(ClassLoader newClassloader) {
        classloader = newClassloader;
    }

    public static void setInstance(Engine engine) {
        instance = engine;
    }

    public abstract Resource createDirectoryResource(Directory var1, Request var2, Response var3) throws IOException;

    public abstract Helper createHelper(Application var1, Context var2);

    public abstract Helper createHelper(Client var1);

    public abstract Helper createHelper(Component var1);

    public abstract Helper createHelper(Server var1);

    public abstract Variant getPreferredVariant(ClientInfo var1, List<Variant> var2, Language var3);

    public abstract void parse(Logger var1, Form var2, Representation var3);

    public abstract void parse(Logger var1, Form var2, String var3, CharacterSet var4);
}

