/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.Arrays;
import java.util.List;
import org.restlet.Connector;
import org.restlet.Context;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.util.Engine;
import org.restlet.util.Helper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client
extends Connector {
    private volatile Helper<Client> helper;

    public Client(Context context, List<Protocol> protocols) {
        this(context, protocols, null);
    }

    public Client(Context context, List<Protocol> protocols, String helperClass) {
        super(context, protocols);
        if (protocols != null && protocols.size() > 0 && Engine.getInstance() != null) {
            this.helper = Engine.getInstance().createHelper(this, helperClass);
        }
    }

    public Client(Context context, Protocol protocol) {
        this(context, protocol == null ? null : Arrays.asList(protocol), null);
    }

    public Client(List<Protocol> protocols) {
        this(null, protocols, null);
    }

    public Client(Protocol protocol) {
        this(null, protocol);
    }

    private Helper<Client> getHelper() {
        return this.helper;
    }

    @Override
    public void handle(Request request, Response response) {
        this.init(request, response);
        if (this.getHelper() != null) {
            this.getHelper().handle(request, response);
        }
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStopped()) {
            super.start();
            if (this.getHelper() != null) {
                this.getHelper().start();
            }
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.isStarted()) {
            if (this.getHelper() != null) {
                this.getHelper().stop();
            }
            super.stop();
        }
    }
}

