/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.io.FileInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.Route;
import org.restlet.Router;
import org.restlet.Server;
import org.restlet.VirtualHost;
import org.restlet.data.LocalReference;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;
import org.restlet.service.LogService;
import org.restlet.service.StatusService;
import org.restlet.util.ClientList;
import org.restlet.util.Engine;
import org.restlet.util.Helper;
import org.restlet.util.ServerList;
import org.restlet.util.Template;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Component
extends Restlet {
    private final ClientList clients;
    private volatile VirtualHost defaultHost;
    private volatile Helper<Component> helper;
    private final List<VirtualHost> hosts = new CopyOnWriteArrayList<VirtualHost>();
    private volatile Router internalRouter;
    private volatile LogService logService;
    private final ServerList servers;
    private volatile StatusService statusService;

    public Component() {
        super(null);
        this.clients = new ClientList(null);
        this.servers = new ServerList(null, this);
        if (Engine.getInstance() != null) {
            this.helper = Engine.getInstance().createHelper(this);
            if (this.helper != null) {
                this.setContext(this.helper.createContext(this.getClass().getCanonicalName()));
                this.defaultHost = new VirtualHost(this.getContext());
                this.internalRouter = new Router(this.getContext());
                this.logService = new LogService(true);
                this.logService.setLoggerName(this.getClass().getCanonicalName() + " (" + this.hashCode() + ")");
                this.statusService = new StatusService(true);
                this.clients.setContext(this.getContext());
                this.servers.setContext(this.getContext());
            }
        }
    }

    public Component(Reference xmlConfigReference) {
        this();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(false);
        dbf.setValidating(false);
        try {
            NodeList statusServiceNodes;
            NodeList logServiceNodes;
            Node node;
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(new FileInputStream(new LocalReference(xmlConfigReference).getFile()));
            NodeList clientNodes = document.getElementsByTagName("client");
            for (int i = 0; i < clientNodes.getLength(); ++i) {
                Node clientNode = clientNodes.item(i);
                Node item = clientNode.getAttributes().getNamedItem("protocol");
                Client client = null;
                if (item == null) {
                    item = clientNode.getAttributes().getNamedItem("protocols");
                    if (item != null) {
                        String[] protocols = item.getNodeValue().split(" ");
                        ArrayList<Protocol> protocolsList = new ArrayList<Protocol>();
                        for (int j = 0; j < protocols.length; ++j) {
                            protocolsList.add(this.getProtocol(protocols[j]));
                        }
                        client = new Client(this.getContext(), protocolsList);
                    }
                } else {
                    client = new Client(this.getContext(), this.getProtocol(item.getNodeValue()));
                }
                if (client == null) continue;
                this.getClients().add(client);
            }
            NodeList serverNodes = document.getElementsByTagName("server");
            for (int i = 0; i < serverNodes.getLength(); ++i) {
                NodeList defaultHostNodes;
                int j;
                Node serverNode = serverNodes.item(i);
                node = serverNode.getAttributes().getNamedItem("protocol");
                Node portNode = serverNode.getAttributes().getNamedItem("port");
                Server server = null;
                if (node == null) {
                    node = serverNode.getAttributes().getNamedItem("protocols");
                    if (node != null) {
                        String[] protocols = node.getNodeValue().split(" ");
                        ArrayList<Protocol> protocolsList = new ArrayList<Protocol>();
                        for (j = 0; j < protocols.length; ++j) {
                            protocolsList.add(this.getProtocol(protocols[j]));
                        }
                        int port = this.getInt(portNode, -1);
                        if (port == -1) {
                            this.getLogger().warning("Please specify a port when defining a list of protocols.");
                        } else {
                            server = new Server(this.getContext(), protocolsList, this.getInt(portNode, -1), this.getServers().getTarget());
                        }
                    }
                } else {
                    Protocol protocol = this.getProtocol(node.getNodeValue());
                    server = new Server(this.getContext(), protocol, this.getInt(portNode, protocol.getDefaultPort()), this.getServers().getTarget());
                }
                if (server != null) {
                    this.getServers().add(server);
                }
                if ((defaultHostNodes = document.getElementsByTagName("defaultHost")).getLength() > 0) {
                    this.parseHost(this.getDefaultHost(), defaultHostNodes.item(0));
                }
                NodeList hostNodes = document.getElementsByTagName("host");
                for (j = 0; j < hostNodes.getLength(); ++j) {
                    VirtualHost host = new VirtualHost();
                    this.parseHost(host, hostNodes.item(j));
                    this.getHosts().add(host);
                }
            }
            NodeList internalRouterNodes = document.getElementsByTagName("internalRouter");
            if (internalRouterNodes.getLength() > 0) {
                Node node2 = internalRouterNodes.item(0);
                Node item = node2.getAttributes().getNamedItem("defaultMatchingMode");
                if (item != null) {
                    this.getInternalRouter().setDefaultMatchingMode(this.getInt(item, this.getInternalRouter().getDefaultMatchingMode()));
                }
                if ((item = node2.getAttributes().getNamedItem("maxAttempts")) != null) {
                    this.getInternalRouter().setMaxAttempts(this.getInt(item, this.getInternalRouter().getMaxAttempts()));
                }
                if ((item = node2.getAttributes().getNamedItem("routingMode")) != null) {
                    this.getInternalRouter().setRoutingMode(this.getInt(item, this.getInternalRouter().getRoutingMode()));
                }
                if ((item = node2.getAttributes().getNamedItem("requiredScore")) != null) {
                    this.getInternalRouter().setRequiredScore(this.getFloat(item, this.getInternalRouter().getRequiredScore()));
                }
                if ((item = node2.getAttributes().getNamedItem("retryDelay")) != null) {
                    this.getInternalRouter().setRetryDelay(this.getLong(item, this.getInternalRouter().getRetryDelay()));
                }
                this.setAttach(this.getInternalRouter(), node2);
            }
            if ((logServiceNodes = document.getElementsByTagName("logService")).getLength() > 0) {
                node = logServiceNodes.item(0);
                Node item = node.getAttributes().getNamedItem("logFormat");
                if (item != null) {
                    this.getLogService().setLogFormat(item.getNodeValue());
                }
                if ((item = node.getAttributes().getNamedItem("loggerName")) != null) {
                    this.getLogService().setLoggerName(item.getNodeValue());
                }
                if ((item = node.getAttributes().getNamedItem("enabled")) != null) {
                    this.getLogService().setEnabled(this.getBoolean(item, true));
                }
                if ((item = node.getAttributes().getNamedItem("identityCheck")) != null) {
                    this.getLogService().setIdentityCheck(this.getBoolean(item, true));
                }
            }
            if ((statusServiceNodes = document.getElementsByTagName("statusService")).getLength() > 0) {
                Node node3 = statusServiceNodes.item(0);
                Node item = node3.getAttributes().getNamedItem("contactEmail");
                if (item != null) {
                    this.getStatusService().setContactEmail(item.getNodeValue());
                }
                if ((item = node3.getAttributes().getNamedItem("enabled")) != null) {
                    this.getStatusService().setEnabled(this.getBoolean(item, true));
                }
                if ((item = node3.getAttributes().getNamedItem("homeRef")) != null) {
                    this.getStatusService().setHomeRef(new Reference(item.getNodeValue()));
                }
                if ((item = node3.getAttributes().getNamedItem("overwrite")) != null) {
                    this.getStatusService().setOverwrite(this.getBoolean(item, true));
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Unable to parse the Component XML configuration.", e);
        }
    }

    private void setAttach(Router router, Node node) {
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!"attach".equals(childNode.getNodeName())) continue;
            String uriPattern = null;
            Node item = childNode.getAttributes().getNamedItem("uriPattern");
            uriPattern = item != null ? item.getNodeValue() : "";
            item = childNode.getAttributes().getNamedItem("default");
            boolean bDefault = this.getBoolean(item, false);
            Route route = null;
            item = childNode.getAttributes().getNamedItem("targetClass");
            if (item != null) {
                route = this.attach(router, item.getNodeValue(), uriPattern, bDefault);
            } else {
                item = childNode.getAttributes().getNamedItem("targetDescriptor");
                if (item != null) {
                    route = this.attachWithDescriptor(router, item.getNodeValue(), uriPattern, bDefault);
                } else {
                    this.getLogger().log(Level.WARNING, "Both targetClass name and targetDescriptor are missing. Couldn't attach a new route.");
                }
            }
            if (route == null) continue;
            Template template = route.getTemplate();
            item = childNode.getAttributes().getNamedItem("matchingMode");
            template.setMatchingMode(this.getInt(item, 1));
            item = childNode.getAttributes().getNamedItem("defaultVariableType");
            template.getDefaultVariable().setType(this.getInt(item, 10));
        }
    }

    private Route attach(Router router, String targetClassName, String uriPattern, boolean defaultRoute) {
        Route route;
        block11: {
            route = null;
            if (targetClassName != null) {
                try {
                    Class<?> targetClass = Engine.classForName(targetClassName);
                    if (Resource.class.isAssignableFrom(targetClass)) {
                        Class<?> resourceClass = targetClass;
                        route = uriPattern != null && !defaultRoute ? router.attach(uriPattern, resourceClass) : router.attachDefault(resourceClass);
                        break block11;
                    }
                    Restlet target = null;
                    try {
                        target = (Restlet)targetClass.getConstructor(Context.class).newInstance(this.getContext());
                    }
                    catch (NoSuchMethodException e) {
                        this.getLogger().log(Level.WARNING, "Couldn't invoke the constructor of the target class. Please check this class has a constructor with a single parameter of type Context. The empty constructor and the context setter will be used instead.", e);
                        target = (Restlet)targetClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        target.setContext(this.getContext());
                    }
                    if (target != null) {
                        route = uriPattern != null && !defaultRoute ? router.attach(uriPattern, target) : router.attachDefault(target);
                    }
                }
                catch (ClassNotFoundException e) {
                    this.getLogger().log(Level.WARNING, "Couldn't find the target class. Please check that your classpath includes " + targetClassName, e);
                }
                catch (InstantiationException e) {
                    this.getLogger().log(Level.WARNING, "Couldn't instantiate the target class. Please check this class has an empty constructor " + targetClassName, e);
                }
                catch (IllegalAccessException e) {
                    this.getLogger().log(Level.WARNING, "Couldn't instantiate the target class. Please check that you have to proper access rights to " + targetClassName, e);
                }
                catch (NoSuchMethodException e) {
                    this.getLogger().log(Level.WARNING, "Couldn't invoke the constructor of the target class. Please check this class has a constructor with a single parameter of Context " + targetClassName, e);
                }
                catch (InvocationTargetException e) {
                    this.getLogger().log(Level.WARNING, "Couldn't instantiate the target class. An exception was thrown while creating " + targetClassName, e);
                }
            }
        }
        return route;
    }

    private Route attachWithDescriptor(Router router, String targetDescriptor, String uriPattern, boolean defaultRoute) {
        Route route = null;
        String targetClassName = null;
        try {
            targetClassName = "org.restlet.ext.wadl.WadlApplication";
            Class<?> targetClass = Engine.classForName(targetClassName);
            Response response = this.getContext().getClientDispatcher().get(targetDescriptor);
            if (response.getStatus().isSuccess() && response.isEntityAvailable()) {
                Representation representation = response.getEntity();
                Application target = (Application)targetClass.getConstructor(Context.class, Representation.class).newInstance(this.getContext(), representation);
                if (target != null) {
                    route = uriPattern != null && !defaultRoute ? router.attach(uriPattern, target) : router.attachDefault(target);
                }
            } else {
                this.getLogger().log(Level.WARNING, "The target descriptor has not been found or is not available, or no client supporting the URI's protocol has been defined on this component. " + targetDescriptor);
            }
        }
        catch (ClassNotFoundException e) {
            this.getLogger().log(Level.WARNING, "Couldn't find the target class. Please check that your classpath includes " + targetClassName, e);
        }
        catch (InstantiationException e) {
            this.getLogger().log(Level.WARNING, "Couldn't instantiate the target class. Please check this class has an empty constructor " + targetClassName, e);
        }
        catch (IllegalAccessException e) {
            this.getLogger().log(Level.WARNING, "Couldn't instantiate the target class. Please check that you have to proper access rights to " + targetClassName, e);
        }
        catch (NoSuchMethodException e) {
            this.getLogger().log(Level.WARNING, "Couldn't invoke the constructor of the target class. Please check this class has a constructor with a single parameter of Context " + targetClassName, e);
        }
        catch (InvocationTargetException e) {
            this.getLogger().log(Level.WARNING, "Couldn't instantiate the target class. An exception was thrown while creating " + targetClassName, e);
        }
        return route;
    }

    private boolean getBoolean(Node node, boolean defaultValue) {
        boolean value = defaultValue;
        if (node != null) {
            try {
                value = Boolean.parseBoolean(node.getNodeValue());
            }
            catch (Exception e) {
                value = defaultValue;
            }
        }
        return value;
    }

    public ClientList getClients() {
        return this.clients;
    }

    public VirtualHost getDefaultHost() {
        return this.defaultHost;
    }

    private float getFloat(Node node, float defaultValue) {
        float value = defaultValue;
        if (node != null) {
            try {
                value = Float.parseFloat(node.getNodeValue());
            }
            catch (Exception e) {
                value = defaultValue;
            }
        }
        return value;
    }

    private Helper<Component> getHelper() {
        return this.helper;
    }

    public List<VirtualHost> getHosts() {
        return this.hosts;
    }

    private int getInt(Node node, int defaultValue) {
        int value = defaultValue;
        if (node != null) {
            try {
                value = Integer.parseInt(node.getNodeValue());
            }
            catch (Exception e) {
                value = defaultValue;
            }
        }
        return value;
    }

    public Router getInternalRouter() {
        return this.internalRouter;
    }

    public LogService getLogService() {
        return this.logService;
    }

    private long getLong(Node node, long defaultValue) {
        long value = defaultValue;
        if (node != null) {
            try {
                value = Long.parseLong(node.getNodeValue());
            }
            catch (Exception e) {
                value = defaultValue;
            }
        }
        return value;
    }

    private Protocol getProtocol(String scheme) {
        Protocol protocol = Protocol.valueOf(scheme);
        if (protocol == null) {
            protocol = new Protocol(scheme);
        }
        return protocol;
    }

    public ServerList getServers() {
        return this.servers;
    }

    public StatusService getStatusService() {
        return this.statusService;
    }

    @Override
    public void handle(Request request, Response response) {
        this.init(request, response);
        if (this.getHelper() != null) {
            this.getHelper().handle(request, response);
        }
    }

    private void parseHost(VirtualHost host, Node hostNode) {
        Node item = hostNode.getAttributes().getNamedItem("hostDomain");
        if (item != null && item.getNodeValue() != null) {
            host.setHostDomain(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("hostPort")) != null && item.getNodeValue() != null) {
            host.setHostPort(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("hostScheme")) != null && item.getNodeValue() != null) {
            host.setHostScheme(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("name")) != null && item.getNodeValue() != null) {
            host.setName(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("resourceDomain")) != null && item.getNodeValue() != null) {
            host.setResourceDomain(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("resourcePort")) != null && item.getNodeValue() != null) {
            host.setResourcePort(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("resourceScheme")) != null && item.getNodeValue() != null) {
            host.setResourceScheme(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("serverAddress")) != null && item.getNodeValue() != null) {
            host.setServerAddress(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("serverPort")) != null && item.getNodeValue() != null) {
            host.setServerPort(item.getNodeValue());
        }
        this.setAttach(host, hostNode);
    }

    public synchronized void setClients(ClientList clients) {
        this.clients.clear();
        if (clients != null) {
            this.clients.addAll(clients);
        }
    }

    public void setDefaultHost(VirtualHost defaultHost) {
        this.defaultHost = defaultHost;
    }

    public synchronized void setHosts(List<VirtualHost> hosts) {
        this.hosts.clear();
        if (hosts != null) {
            this.hosts.addAll(hosts);
        }
    }

    public void setInternalRouter(Router internalRouter) {
        this.internalRouter = internalRouter;
    }

    public void setLogService(LogService logService) {
        this.logService = logService;
    }

    public synchronized void setServers(ServerList servers) {
        this.servers.clear();
        if (servers != null) {
            this.servers.addAll(servers);
        }
    }

    public void setStatusService(StatusService statusService) {
        this.statusService = statusService;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStopped()) {
            this.startClients();
            this.startServers();
            this.startHelper();
            super.start();
        }
    }

    protected synchronized void startClients() throws Exception {
        if (this.clients != null) {
            for (Client client : this.clients) {
                client.start();
            }
        }
    }

    protected synchronized void startHelper() throws Exception {
        if (this.getHelper() != null) {
            this.getHelper().start();
        }
    }

    protected synchronized void startServers() throws Exception {
        if (this.servers != null) {
            for (Server server : this.servers) {
                server.start();
            }
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        this.stopHelper();
        this.stopServers();
        this.stopClients();
        super.stop();
    }

    protected synchronized void stopClients() throws Exception {
        if (this.clients != null) {
            for (Client client : this.clients) {
                client.stop();
            }
        }
    }

    protected synchronized void stopHelper() throws Exception {
        if (this.getHelper() != null) {
            this.getHelper().stop();
        }
    }

    protected synchronized void stopServers() throws Exception {
        if (this.servers != null) {
            for (Server server : this.servers) {
                server.stop();
            }
        }
    }

    public synchronized void updateHosts() throws Exception {
        this.getHelper().update();
    }

    public static void main(String[] args) throws Exception {
        try {
            if (args == null || args.length != 1) {
                System.err.println("Can't launch the component. Requires the path to an XML configuration file.\n");
            } else {
                new Component(LocalReference.createFileReference(args[0])).start();
            }
        }
        catch (Exception e) {
            System.err.println("Can't launch the component.\nAn unexpected exception occurred:");
            e.printStackTrace(System.err);
        }
    }
}

