/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.util.Template;

public abstract class Handler {
    private Context context;
    private Request request;
    private Response response;

    public Handler() {
    }

    public Handler(Context context, Request request, Response response) {
        this.context = context;
        this.request = request;
        this.response = response;
    }

    public boolean allowDelete() {
        return false;
    }

    public boolean allowGet() {
        return false;
    }

    public boolean allowHead() {
        return this.allowGet();
    }

    public boolean allowOptions() {
        return true;
    }

    public boolean allowPost() {
        return false;
    }

    public boolean allowPut() {
        return false;
    }

    public Reference generateRef(String uriTemplate) {
        Template tplt = new Template(this.getLogger(), uriTemplate);
        return new Reference(tplt.format(this.getRequest(), this.getResponse()));
    }

    public Application getApplication() {
        return this.getContext().getApplication();
    }

    public Context getContext() {
        if (this.context == null) {
            this.context = new Context(this.getClass().getCanonicalName());
        }
        return this.context;
    }

    public Logger getLogger() {
        return this.getContext().getLogger();
    }

    public Form getQuery() {
        return this.getRequest().getResourceRef().getQueryAsForm();
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public void handleDelete() {
        this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
    }

    public void handleGet() {
        this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
    }

    public void handleHead() {
        this.handleGet();
    }

    public void handleOptions() {
        this.updateAllowedMethods();
        this.getResponse().setStatus(Status.SUCCESS_OK);
    }

    public void handlePost() {
        this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
    }

    public void handlePut() {
        this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
    }

    public void init(Context context, Request request, Response response) {
        this.context = context;
        this.request = request;
        this.response = response;
    }

    private Object invoke(java.lang.reflect.Method method, Object ... args) {
        Object result = null;
        if (method != null) {
            try {
                result = method.invoke((Object)this, args);
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Couldn't invoke the handle method for \"" + method + "\"", e);
            }
        }
        return result;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    protected void updateAllowedMethods() {
        Set<Method> allowedMethods = this.getResponse().getAllowedMethods();
        for (java.lang.reflect.Method classMethod : this.getClass().getMethods()) {
            if (!classMethod.getName().startsWith("allow") || classMethod.getParameterTypes().length != 0 || !((Boolean)this.invoke(classMethod, new Object[0])).booleanValue()) continue;
            Method allowedMethod = Method.valueOf(classMethod.getName().substring(5));
            allowedMethods.add(allowedMethod);
        }
    }
}

