/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.Arrays;
import java.util.List;
import org.restlet.Connector;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.util.Engine;
import org.restlet.util.Helper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
extends Connector {
    private volatile String address;
    private volatile Helper<Server> helper;
    private volatile int port;
    private volatile Restlet target;

    public Server(Context context, List<Protocol> protocols, int port, Restlet target) {
        this(context, protocols, null, port, target);
    }

    public Server(Context context, List<Protocol> protocols, String address, int port, Restlet target) {
        this(context, protocols, address, port, target, null);
    }

    public Server(Context context, List<Protocol> protocols, String address, int port, Restlet target, String helperClass) {
        super(context, protocols);
        this.address = address;
        this.port = port;
        this.target = target;
        if (Engine.getInstance() != null) {
            this.helper = Engine.getInstance().createHelper(this, helperClass);
        }
    }

    public Server(Context context, Protocol protocol, int port, Restlet target) {
        this(context, protocol, null, port, target);
    }

    public Server(Context context, Protocol protocol, Restlet target) {
        this(context, protocol, null, protocol == null ? -1 : protocol.getDefaultPort(), target);
    }

    public Server(Context context, Protocol protocol, String address, int port, Restlet target) {
        this(context, protocol == null ? null : Arrays.asList(protocol), address, port, target);
    }

    public Server(List<Protocol> protocols, int port, Restlet target) {
        this(null, protocols, port, target);
    }

    public Server(List<Protocol> protocols, String address, int port, Restlet target) {
        this(null, protocols, address, port, target);
    }

    public Server(Protocol protocol, int port, Restlet target) {
        this(null, protocol, port, target);
    }

    public Server(Protocol protocol, Restlet target) {
        this(null, protocol, target);
    }

    public Server(Protocol protocol, String address, int port, Restlet target) {
        this(null, protocol, address, port, target);
    }

    public Server(Protocol protocol, String address, Restlet target) {
        this(null, protocol, address, protocol.getDefaultPort(), target);
    }

    public String getAddress() {
        return this.address;
    }

    public int getEphemeralPort() {
        return (Integer)this.getHelper().getAttributes().get("ephemeralPort");
    }

    private Helper<Server> getHelper() {
        return this.helper;
    }

    public int getPort() {
        return this.port;
    }

    public Restlet getTarget() {
        return this.target;
    }

    @Override
    public void handle(Request request, Response response) {
        this.init(request, response);
        if (this.getTarget() != null) {
            this.getTarget().handle(request, response);
        }
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    protected void setAddress(String address) {
        this.address = address;
    }

    protected void setPort(int port) {
        this.port = port;
    }

    public void setTarget(Restlet target) {
        this.target = target;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStopped()) {
            super.start();
            if (this.getHelper() != null) {
                this.getHelper().start();
            }
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.isStarted()) {
            if (this.getHelper() != null) {
                this.getHelper().stop();
            }
            super.stop();
        }
    }
}

