/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.service.ConnectorService;
import org.restlet.service.ConverterService;
import org.restlet.service.DecoderService;
import org.restlet.service.MetadataService;
import org.restlet.service.StatusService;
import org.restlet.service.TunnelService;
import org.restlet.util.Engine;
import org.restlet.util.Helper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
extends Restlet {
    private static final ThreadLocal<Application> CURRENT = new ThreadLocal();
    private volatile String author;
    private volatile ConnectorService connectorService;
    @Deprecated
    private volatile ConverterService converterService;
    private volatile DecoderService decoderService;
    private volatile String description;
    private volatile Helper<Application> helper;
    private volatile MetadataService metadataService;
    private volatile String name;
    private volatile String owner;
    private volatile Restlet root;
    private volatile StatusService statusService;
    private volatile TunnelService tunnelService;

    public static Application getCurrent() {
        return CURRENT.get();
    }

    public static void setCurrent(Application application) {
        CURRENT.set(application);
    }

    public Application() {
        this(null);
    }

    public Application(Context parentContext) {
        super(null);
        if (Engine.getInstance() != null) {
            this.helper = Engine.getInstance().createHelper(this, parentContext);
            String applicationName = this.getName() == null ? Integer.toString(this.hashCode()) : this.getName();
            String loggerName = Application.class.getCanonicalName() + "." + applicationName;
            this.setContext(this.helper.createContext(loggerName));
        }
        this.name = null;
        this.description = null;
        this.author = null;
        this.owner = null;
        this.root = null;
        this.connectorService = new ConnectorService();
        this.converterService = new ConverterService();
        this.decoderService = new DecoderService(true);
        this.metadataService = new MetadataService();
        this.statusService = new StatusService(true);
        this.tunnelService = new TunnelService(true, true, true);
    }

    public Restlet createRoot() {
        return null;
    }

    public String getAuthor() {
        return this.author;
    }

    public ConnectorService getConnectorService() {
        return this.connectorService;
    }

    @Deprecated
    public ConverterService getConverterService() {
        return this.converterService;
    }

    public DecoderService getDecoderService() {
        return this.decoderService;
    }

    public String getDescription() {
        return this.description;
    }

    private Helper<Application> getHelper() {
        return this.helper;
    }

    public MetadataService getMetadataService() {
        return this.metadataService;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public synchronized Restlet getRoot() {
        if (this.root == null) {
            this.root = this.createRoot();
        }
        return this.root;
    }

    public StatusService getStatusService() {
        return this.statusService;
    }

    public TunnelService getTunnelService() {
        return this.tunnelService;
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        if (this.getHelper() != null) {
            this.getHelper().handle(request, response);
        }
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setConnectorService(ConnectorService connectorService) {
        this.connectorService = connectorService;
    }

    @Deprecated
    public void setConverterService(ConverterService converterService) {
        this.converterService = converterService;
    }

    public void setDecoderService(DecoderService decoderService) {
        this.decoderService = decoderService;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMetadataService(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public synchronized void setRoot(Restlet root) {
        this.root = root;
    }

    public void setStatusService(StatusService statusService) {
        this.statusService = statusService;
    }

    public void setTunnelService(TunnelService tunnelService) {
        this.tunnelService = tunnelService;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStopped()) {
            super.start();
            if (this.getHelper() != null) {
                this.getHelper().start();
            }
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.isStarted()) {
            if (this.getHelper() != null) {
                this.getHelper().stop();
            }
            super.stop();
        }
    }
}

