/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Uniform;
import org.restlet.VirtualHost;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.data.Response;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context {
    private static final ThreadLocal<Context> CURRENT = new ThreadLocal();
    private volatile ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private volatile Logger logger;
    private volatile Series<Parameter> parameters;

    public static Context getCurrent() {
        return CURRENT.get();
    }

    public static void setCurrent(Context context) {
        CURRENT.set(context);
    }

    public Context() {
        this("org.restlet");
    }

    public Context(Logger logger) {
        this.logger = logger;
        this.parameters = new Form((List<Parameter>)new CopyOnWriteArrayList<Parameter>());
    }

    public Context(String loggerName) {
        this(Logger.getLogger(loggerName));
    }

    @Deprecated
    public Application getApplication() {
        return Application.getCurrent();
    }

    public ConcurrentMap<String, Object> getAttributes() {
        return this.attributes;
    }

    public Uniform getClientDispatcher() {
        return null;
    }

    @Deprecated
    public Uniform getDispatcher() {
        return this.getClientDispatcher();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Series<Parameter> getParameters() {
        return this.parameters;
    }

    public Uniform getServerDispatcher() {
        return null;
    }

    public Thread getThread(final Runnable task) {
        final Application currentApplication = Application.getCurrent();
        final Context currentContext = Context.getCurrent();
        final Integer currentVirtualHost = VirtualHost.getCurrent();
        final Response currentResponse = Response.getCurrent();
        Thread result = new Thread(new Runnable(){

            public void run() {
                Response.setCurrent(currentResponse);
                Context.setCurrent(currentContext);
                VirtualHost.setCurrent(currentVirtualHost);
                Application.setCurrent(currentApplication);
                task.run();
            }
        });
        return result;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes instanceof ConcurrentMap ? (ConcurrentMap<Object, Object>)attributes : new ConcurrentHashMap<String, Object>(attributes);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setParameters(Series<Parameter> parameters) {
        this.parameters = parameters;
    }
}

