/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Finder;
import org.restlet.Handler;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.ReferenceList;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Representation;
import org.restlet.resource.Variant;
import org.restlet.util.Engine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Directory
extends Finder {
    private volatile Comparator<Reference> comparator;
    private volatile boolean deeplyAccessible;
    private volatile String indexName;
    private volatile boolean listingAllowed;
    private volatile boolean modifiable;
    private volatile boolean negotiateContent;
    private volatile Reference rootRef;

    public Directory(Context context, Reference rootLocalReference) {
        super(context);
        String rootIdentifier = rootLocalReference.getTargetRef().getIdentifier();
        this.rootRef = rootIdentifier.endsWith("/") ? new Reference(rootIdentifier) : new Reference(rootIdentifier + "/");
        this.comparator = new AlphaNumericComparator();
        this.deeplyAccessible = true;
        this.indexName = "index";
        this.listingAllowed = false;
        this.modifiable = false;
        this.negotiateContent = true;
    }

    public Directory(Context context, String rootUri) {
        this(context, new Reference(rootUri));
    }

    @Override
    public Handler findTarget(Request request, Response response) {
        try {
            return Engine.getInstance().createDirectoryResource(this, request, response);
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, "Unable to find the directory's resource", ioe);
            return null;
        }
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Representation getIndexRepresentation(Variant variant, ReferenceList indexContent) {
        Representation result = null;
        if (variant.getMediaType().equals(MediaType.TEXT_HTML)) {
            result = indexContent.getWebRepresentation();
        } else if (variant.getMediaType().equals(MediaType.TEXT_URI_LIST)) {
            result = indexContent.getTextRepresentation();
        }
        return result;
    }

    public List<Variant> getIndexVariants(ReferenceList indexContent) {
        ArrayList<Variant> result = new ArrayList<Variant>();
        result.add(new Variant(MediaType.TEXT_HTML));
        result.add(new Variant(MediaType.TEXT_URI_LIST));
        return result;
    }

    public Reference getRootRef() {
        return this.rootRef;
    }

    public boolean isDeeplyAccessible() {
        return this.deeplyAccessible;
    }

    public boolean isListingAllowed() {
        return this.listingAllowed;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public boolean isNegotiateContent() {
        return this.negotiateContent;
    }

    public void setDeeplyAccessible(boolean deeplyAccessible) {
        this.deeplyAccessible = deeplyAccessible;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setListingAllowed(boolean listingAllowed) {
        this.listingAllowed = listingAllowed;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    public void setNegotiateContent(boolean negotiateContent) {
        this.negotiateContent = negotiateContent;
    }

    public void setRootRef(Reference rootRef) {
        this.rootRef = rootRef;
    }

    public Comparator<Reference> getComparator() {
        return this.comparator;
    }

    public void setAlphaComparator() {
        this.setComparator(new AlphabeticalComparator());
    }

    public void setAlphaNumComparator() {
        this.setComparator(new AlphabeticalComparator());
    }

    public void setComparator(Comparator<Reference> comparator) {
        this.comparator = comparator;
    }

    private class AlphaNumericComparator
    extends AlphabeticalComparator {
        private static final long serialVersionUID = 1L;

        private AlphaNumericComparator() {
        }

        protected boolean isNotDigit(char x) {
            return x > '9' || x < '0';
        }

        public int compare(String uri0, String uri1) {
            int msd = 0;
            int diff = 0;
            int llength = uri0.length();
            int rlength = uri1.length();
            int min = rlength < llength ? rlength : llength;
            for (int ptr = 0; ptr < min; ++ptr) {
                boolean rAtEnd;
                char a = uri0.charAt(ptr);
                char b = uri1.charAt(ptr);
                diff = a - b;
                if (a > '9' || b > '9' || a < '0' || b < '0') {
                    if (diff != 0) {
                        return diff;
                    }
                    msd = 0;
                    continue;
                }
                if (msd == 0) {
                    msd = diff;
                }
                boolean bl = rAtEnd = rlength - ptr < 2;
                if (llength - ptr < 2) {
                    if (rAtEnd) {
                        return msd;
                    }
                    return -1;
                }
                if (rAtEnd) {
                    return 1;
                }
                boolean rHasNoMoreDigits = this.isNotDigit(uri1.charAt(ptr + 1));
                if (this.isNotDigit(uri0.charAt(ptr + 1))) {
                    if (rHasNoMoreDigits && msd != 0) {
                        return msd;
                    }
                    if (rHasNoMoreDigits) continue;
                    return -1;
                }
                if (!rHasNoMoreDigits) continue;
                return 1;
            }
            return llength - rlength;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AlphabeticalComparator
    implements Comparator<Reference>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private AlphabeticalComparator() {
        }

        @Override
        public int compare(Reference rep0, Reference rep1) {
            boolean bRep1Null;
            boolean bRep0Null = rep0.getIdentifier() == null;
            boolean bl = bRep1Null = rep1.getIdentifier() == null;
            if (bRep0Null && bRep1Null) {
                return 0;
            }
            if (bRep0Null) {
                return -1;
            }
            if (bRep1Null) {
                return 1;
            }
            return this.compare(rep0.toString(false, false), rep1.toString(false, false));
        }

        @Override
        public int compare(String uri0, String uri1) {
            return uri0.compareTo(uri1);
        }
    }
}

