/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class Restlet
extends Uniform {
    private static final String UNABLE_TO_START = "Unable to start the Restlet";
    private volatile Context context;
    private volatile boolean started;

    public Restlet() {
        this(null);
    }

    public Restlet(Context context) {
        if (context == null) {
            String logName = this.getClass().getCanonicalName();
            if (logName == null) {
                logName = Restlet.class.getCanonicalName();
            }
            this.context = new Context(logName);
        } else {
            this.context = context;
        }
        this.started = false;
    }

    public Application getApplication() {
        return Application.getCurrent();
    }

    public Context getContext() {
        return this.context;
    }

    public Logger getLogger() {
        return this.getContext() != null ? this.getContext().getLogger() : Logger.getLogger(this.getClass().getCanonicalName());
    }

    public void handle(Request request, Response response) {
        this.init(request, response);
    }

    @Deprecated
    protected synchronized void init(Request request, Response response) {
        Response.setCurrent(response);
        Context.setCurrent(this.getContext());
        if (this.isStopped()) {
            try {
                this.start();
            }
            catch (Exception e) {
                this.getContext().getLogger().log(Level.WARNING, UNABLE_TO_START, e);
                response.setStatus(Status.SERVER_ERROR_INTERNAL);
            }
            if (!this.isStarted()) {
                this.getContext().getLogger().log(Level.WARNING, UNABLE_TO_START);
                response.setStatus(Status.SERVER_ERROR_INTERNAL);
            }
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return !this.started;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public synchronized void start() throws Exception {
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        this.started = false;
    }
}

