/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.service;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataService {
    private volatile Encoding defaultEncoding = Encoding.IDENTITY;
    private volatile Language defaultLanguage = Language.ENGLISH_US;
    private volatile MediaType defaultMediaType = MediaType.APPLICATION_OCTET_STREAM;
    private final List<MetadataExtension> mappings = new CopyOnWriteArrayList<MetadataExtension>();

    public MetadataService() {
        this.addCommonExtensions();
    }

    public void addCommonExtensions() {
        this.addExtension("en", Language.ENGLISH);
        this.addExtension("es", Language.SPANISH);
        this.addExtension("fr", Language.FRENCH);
        this.addExtension("ai", MediaType.APPLICATION_POSTSCRIPT);
        this.addExtension("atom", MediaType.APPLICATION_ATOM_XML);
        this.addExtension("au", MediaType.AUDIO_BASIC);
        this.addExtension("bin", MediaType.APPLICATION_OCTET_STREAM);
        this.addExtension("bmp", MediaType.IMAGE_BMP);
        this.addExtension("class", MediaType.APPLICATION_JAVA);
        this.addExtension("css", MediaType.TEXT_CSS);
        this.addExtension("dib", MediaType.IMAGE_BMP);
        this.addExtension("doc", MediaType.APPLICATION_WORD);
        this.addExtension("dtd", MediaType.APPLICATION_XML_DTD);
        this.addExtension("eps", MediaType.APPLICATION_POSTSCRIPT);
        this.addExtension("exe", MediaType.APPLICATION_OCTET_STREAM);
        this.addExtension("fmt", Encoding.FREEMARKER);
        this.addExtension("gif", MediaType.IMAGE_GIF);
        this.addExtension("hqx", MediaType.APPLICATION_MAC_BINHEX40);
        this.addExtension("htm", MediaType.TEXT_HTML);
        this.addExtension("html", MediaType.TEXT_HTML);
        this.addExtension("ico", MediaType.IMAGE_ICON);
        this.addExtension("jad", MediaType.TEXT_J2ME_APP_DESCRIPTOR);
        this.addExtension("jar", MediaType.APPLICATION_JAVA_ARCHIVE);
        this.addExtension("java", MediaType.TEXT_PLAIN);
        this.addExtension("jnlp", MediaType.APPLICATION_JNLP);
        this.addExtension("jpe", MediaType.IMAGE_JPEG);
        this.addExtension("jpeg", MediaType.IMAGE_JPEG);
        this.addExtension("jpg", MediaType.IMAGE_JPEG);
        this.addExtension("js", MediaType.APPLICATION_JAVASCRIPT);
        this.addExtension("jsf", MediaType.TEXT_PLAIN);
        this.addExtension("json", MediaType.APPLICATION_JSON);
        this.addExtension("kar", MediaType.AUDIO_MIDI);
        this.addExtension("latex", MediaType.APPLICATION_LATEX);
        this.addExtension("man", MediaType.APPLICATION_TROFF_MAN);
        this.addExtension("mathml", MediaType.APPLICATION_MATHML_XML);
        this.addExtension("mid", MediaType.AUDIO_MIDI);
        this.addExtension("midi", MediaType.AUDIO_MIDI);
        this.addExtension("mov", MediaType.VIDEO_QUICKTIME);
        this.addExtension("mp2", MediaType.AUDIO_MPEG);
        this.addExtension("mp3", MediaType.AUDIO_MPEG);
        this.addExtension("mp4", MediaType.VIDEO_MP4);
        this.addExtension("mpe", MediaType.VIDEO_MPEG);
        this.addExtension("mpeg", MediaType.VIDEO_MPEG);
        this.addExtension("mpg", MediaType.VIDEO_MPEG);
        this.addExtension("pdf", MediaType.APPLICATION_PDF);
        this.addExtension("png", MediaType.IMAGE_PNG);
        this.addExtension("pps", MediaType.APPLICATION_POWERPOINT);
        this.addExtension("ppt", MediaType.APPLICATION_POWERPOINT);
        this.addExtension("ps", MediaType.APPLICATION_POSTSCRIPT);
        this.addExtension("qt", MediaType.VIDEO_QUICKTIME);
        this.addExtension("rdf", MediaType.APPLICATION_RDF_XML);
        this.addExtension("rnc", MediaType.APPLICATION_RELAXNG_COMPACT);
        this.addExtension("rng", MediaType.APPLICATION_RELAXNG_XML);
        this.addExtension("rss", MediaType.APPLICATION_RSS_XML);
        this.addExtension("rtf", MediaType.APPLICATION_RTF);
        this.addExtension("sit", MediaType.APPLICATION_STUFFIT);
        this.addExtension("snd", MediaType.AUDIO_BASIC);
        this.addExtension("svg", MediaType.IMAGE_SVG);
        this.addExtension("swf", MediaType.APPLICATION_FLASH);
        this.addExtension("tar", MediaType.APPLICATION_TAR);
        this.addExtension("tex", MediaType.APPLICATION_TEX);
        this.addExtension("tif", MediaType.IMAGE_TIFF);
        this.addExtension("tiff", MediaType.IMAGE_TIFF);
        this.addExtension("txt", MediaType.TEXT_PLAIN, true);
        this.addExtension("ulw", MediaType.AUDIO_BASIC);
        this.addExtension("vm", Encoding.VELOCITY);
        this.addExtension("vrml", MediaType.MODEL_VRML);
        this.addExtension("vxml", MediaType.APPLICATION_VOICEXML);
        this.addExtension("wadl", MediaType.APPLICATION_WADL_XML);
        this.addExtension("wav", MediaType.AUDIO_WAV);
        this.addExtension("wrl", MediaType.MODEL_VRML);
        this.addExtension("xht", MediaType.APPLICATION_XHTML_XML);
        this.addExtension("xhtml", MediaType.APPLICATION_XHTML_XML);
        this.addExtension("xls", MediaType.APPLICATION_EXCEL);
        this.addExtension("xml", MediaType.TEXT_XML);
        this.addExtension("xml", MediaType.APPLICATION_XML);
        this.addExtension("xsd", MediaType.APPLICATION_W3C_SCHEMA_XML);
        this.addExtension("xslt", MediaType.APPLICATION_W3C_XSLT);
        this.addExtension("xul", MediaType.APPLICATION_XUL);
        this.addExtension("z", MediaType.APPLICATION_COMPRESS);
        this.addExtension("zip", MediaType.APPLICATION_ZIP);
    }

    public void addExtension(String extension, Metadata metadata) {
        this.addExtension(extension, metadata, false);
    }

    public void addExtension(String extension, Metadata metadata, boolean preferred) {
        if (preferred) {
            this.mappings.add(0, new MetadataExtension(extension, metadata));
        } else {
            this.mappings.add(new MetadataExtension(extension, metadata));
        }
    }

    public void clearExtensions() {
        this.mappings.clear();
    }

    public Encoding getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public Language getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public MediaType getDefaultMediaType() {
        return this.defaultMediaType;
    }

    public String getExtension(Metadata metadata) {
        if (metadata != null) {
            for (MetadataExtension metadataExtension : this.mappings) {
                if (!metadata.equals(metadataExtension.getMetadata())) continue;
                return metadataExtension.getName();
            }
        }
        return null;
    }

    @Deprecated
    public Map<String, Metadata> getMappings() {
        TreeMap<String, Metadata> result = new TreeMap<String, Metadata>();
        for (MetadataExtension metadataExtension : this.mappings) {
            result.put(metadataExtension.getName(), metadataExtension.getMetadata());
        }
        return result;
    }

    public Metadata getMetadata(String extension) {
        if (extension != null) {
            for (MetadataExtension metadataExtension : this.mappings) {
                if (!extension.equals(metadataExtension.getName())) continue;
                return metadataExtension.getMetadata();
            }
        }
        return null;
    }

    public void setDefaultEncoding(Encoding defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setDefaultLanguage(Language defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public void setDefaultMediaType(MediaType defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
    }

    @Deprecated
    public void setMappings(Map<String, Metadata> mappings) {
        this.mappings.clear();
        for (String extension : mappings.keySet()) {
            this.addExtension(extension, mappings.get(extension), false);
        }
    }

    private class MetadataExtension {
        private final Metadata metadata;
        private final String name;

        public MetadataExtension(String name, Metadata metadata) {
            this.name = name;
            this.metadata = metadata;
        }

        public Metadata getMetadata() {
            return this.metadata;
        }

        public String getName() {
            return this.name;
        }
    }
}

