/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.resource.Representation;
import org.restlet.resource.WriterRepresentation;

public final class ByteUtils {
    public static void exhaust(InputStream input) throws IOException {
        if (input != null) {
            byte[] buf = new byte[2048];
            int read = input.read(buf);
            while (read != -1) {
                read = input.read(buf);
            }
        }
    }

    public static ReadableByteChannel getChannel(InputStream inputStream) {
        return inputStream != null ? Channels.newChannel(inputStream) : null;
    }

    public static WritableByteChannel getChannel(OutputStream outputStream) {
        return outputStream != null ? Channels.newChannel(outputStream) : null;
    }

    public static ReadableByteChannel getChannel(final Representation representation) throws IOException {
        final Pipe pipe = Pipe.open();
        Context context = Context.getCurrent();
        Thread writer = context.getThread(new Runnable(){

            public void run() {
                try {
                    Pipe.SinkChannel wbc = pipe.sink();
                    representation.write(wbc);
                    wbc.close();
                }
                catch (IOException ioe) {
                    Logger.getLogger(ByteUtils.class.getCanonicalName()).log(Level.FINE, "Error while writing to the piped channel.", ioe);
                }
            }
        });
        writer.setDaemon(false);
        writer.start();
        return pipe.source();
    }

    public static Reader getReader(InputStream stream, CharacterSet characterSet) throws UnsupportedEncodingException {
        if (characterSet != null) {
            return new InputStreamReader(stream, characterSet.getName());
        }
        return new InputStreamReader(stream);
    }

    public static Reader getReader(final WriterRepresentation representation) throws IOException {
        final PipedWriter pipedWriter = new PipedWriter();
        PipedReader pipedReader = new PipedReader(pipedWriter);
        Context context = Context.getCurrent();
        Thread writer = context.getThread(new Runnable(){

            public void run() {
                try {
                    representation.write(pipedWriter);
                }
                catch (IOException ioe) {
                    Logger.getLogger(ByteUtils.class.getCanonicalName()).log(Level.FINE, "Error while writing to the piped reader.", ioe);
                }
            }
        });
        writer.setDaemon(false);
        writer.start();
        return pipedReader;
    }

    public static InputStream getStream(ReadableByteChannel readableChannel) {
        NbChannelInputStream result = null;
        if (readableChannel != null) {
            result = new NbChannelInputStream(readableChannel);
        }
        return result;
    }

    public static InputStream getStream(Reader reader, CharacterSet characterSet) {
        return new ReaderInputStream(reader, characterSet);
    }

    public static InputStream getStream(final Representation representation) {
        if (representation == null) {
            return null;
        }
        final PipeStream pipe = new PipeStream();
        Context context = Context.getCurrent();
        Thread writer = context.getThread(new Runnable(){

            public void run() {
                try {
                    OutputStream os = pipe.getOutputStream();
                    representation.write(os);
                    os.write(-1);
                    os.close();
                }
                catch (IOException ioe) {
                    Logger.getLogger(ByteUtils.class.getCanonicalName()).log(Level.FINE, "Error while writing to the piped input stream.", ioe);
                }
            }
        });
        writer.setDaemon(false);
        writer.start();
        return pipe.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream getStream(WritableByteChannel writableChannel) {
        OutputStream result = null;
        if (writableChannel instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)((Object)writableChannel);
            Object object = selectableChannel.blockingLock();
            synchronized (object) {
                result = selectableChannel.isBlocking() ? Channels.newOutputStream(writableChannel) : new NbChannelOutputStream(writableChannel);
            }
        } else {
            result = new NbChannelOutputStream(writableChannel);
        }
        return result;
    }

    public static OutputStream getStream(Writer writer) {
        return new WriterOutputStream(writer);
    }

    public static String toString(InputStream inputStream) {
        return ByteUtils.toString(inputStream, null);
    }

    public static String toString(InputStream inputStream, CharacterSet characterSet) {
        String result = null;
        if (inputStream != null) {
            try {
                result = characterSet != null ? ByteUtils.toString(new InputStreamReader(inputStream, characterSet.getName())) : ByteUtils.toString(new InputStreamReader(inputStream));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static String toString(Reader reader) {
        String result = null;
        if (reader != null) {
            try {
                StringBuilder sb = new StringBuilder();
                BufferedReader br = new BufferedReader(reader);
                int nextChar = br.read();
                while (nextChar != -1) {
                    sb.append((char)nextChar);
                    nextChar = br.read();
                }
                br.close();
                result = sb.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static void write(InputStream inputStream, OutputStream outputStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[2048];
        while ((bytesRead = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, bytesRead);
        }
        inputStream.close();
    }

    public static void write(ReadableByteChannel readableChannel, WritableByteChannel writableChannel) throws IOException {
        if (readableChannel != null && writableChannel != null) {
            ByteUtils.write(new NbChannelInputStream(readableChannel), new NbChannelOutputStream(writableChannel));
        }
    }

    public static void write(Reader reader, Writer writer) throws IOException {
        int charsRead;
        char[] buffer = new char[2048];
        while ((charsRead = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, charsRead);
        }
        reader.close();
    }

    private ByteUtils() {
    }

    private static final class WriterOutputStream
    extends OutputStream {
        private final Writer writer;

        public WriterOutputStream(Writer writer) {
            this.writer = writer;
        }

        public void close() throws IOException {
            super.close();
            this.writer.close();
        }

        public void flush() throws IOException {
            super.flush();
            this.writer.flush();
        }

        public void write(int b) throws IOException {
            this.writer.write(b);
        }
    }

    private static final class SelectorFactory {
        public static int maxSelectors = 20;
        private static final Stack<Selector> selectors = new Stack();
        public static long timeout = 5000L;

        private SelectorFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final Selector getSelector() {
            Stack<Selector> stack = selectors;
            synchronized (stack) {
                Selector selector = null;
                try {
                    if (selectors.size() != 0) {
                        selector = selectors.pop();
                    }
                }
                catch (EmptyStackException ex) {
                    // empty catch block
                }
                try {
                    for (int attempts = 0; selector == null && attempts < 2; ++attempts) {
                        selectors.wait(timeout);
                        try {
                            if (selectors.size() == 0) continue;
                            selector = selectors.pop();
                            continue;
                        }
                        catch (EmptyStackException ex) {
                            break;
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return selector;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final void returnSelector(Selector s) {
            Stack<Selector> stack = selectors;
            synchronized (stack) {
                selectors.push(s);
                if (selectors.size() == 1) {
                    selectors.notify();
                }
            }
        }

        static {
            try {
                for (int i = 0; i < maxSelectors; ++i) {
                    selectors.add(Selector.open());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class ReaderInputStream
    extends InputStream {
        private byte[] buffer;
        private CharacterSet characterSet;
        private int index;
        private BufferedReader localReader;

        public ReaderInputStream(Reader reader, CharacterSet characterSet) {
            this.localReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            this.buffer = null;
            this.index = -1;
            this.characterSet = characterSet;
        }

        public int read() throws IOException {
            String line;
            int result = -1;
            if (this.buffer == null && (line = this.localReader.readLine()) != null) {
                this.buffer = line.getBytes(this.characterSet.getName());
                this.index = 0;
            }
            if (this.buffer != null) {
                result = this.buffer[this.index++];
                if (this.index == this.buffer.length) {
                    this.buffer = null;
                }
            }
            return result;
        }
    }

    private static final class PipeStream {
        private static final long QUEUE_TIMEOUT = 5L;
        private final BlockingQueue<Integer> queue = new ArrayBlockingQueue<Integer>(1024);

        public InputStream getInputStream() {
            return new InputStream(){
                private boolean endReached = false;

                public int read() throws IOException {
                    try {
                        if (this.endReached) {
                            return -1;
                        }
                        Integer value = (Integer)PipeStream.this.queue.poll(5L, TimeUnit.SECONDS);
                        if (value == null) {
                            throw new IOException("Timeout while reading from the queue-based input stream");
                        }
                        this.endReached = value == -1;
                        return value;
                    }
                    catch (InterruptedException ie) {
                        throw new IOException("Interruption occurred while writing in the queue");
                    }
                }
            };
        }

        public OutputStream getOutputStream() {
            return new OutputStream(){

                public void write(int b) throws IOException {
                    try {
                        if (!PipeStream.this.queue.offer(b, 5L, TimeUnit.SECONDS)) {
                            throw new IOException("Timeout while writing to the queue-based output stream");
                        }
                    }
                    catch (InterruptedException ie) {
                        throw new IOException("Interruption occurred while writing in the queue");
                    }
                }
            };
        }
    }

    private static final class NbChannelOutputStream
    extends OutputStream {
        private ByteBuffer bb = ByteBuffer.allocate(8192);
        private WritableByteChannel channel;
        private SelectionKey selectionKey;
        private Selector selector;

        public NbChannelOutputStream(WritableByteChannel channel) {
            this.channel = channel;
        }

        public void close() throws IOException {
            if (this.selectionKey != null) {
                this.selectionKey.cancel();
            }
            if (this.selector != null) {
                this.selector.close();
            }
            super.close();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.bb.clear();
            this.bb.put(b, off, len);
            this.bb.flip();
            if (this.channel != null && this.bb != null) {
                try {
                    while (this.bb.hasRemaining()) {
                        int bytesWritten = this.channel.write(this.bb);
                        if (bytesWritten < 0) {
                            throw new IOException("Unexpected negative number of bytes written.");
                        }
                        if (bytesWritten != 0 || SelectorFactory.getSelector().select(10000L) != 0) continue;
                        throw new IOException("Unable to select the channel to write to it. Selection timed out.");
                    }
                }
                catch (IOException ioe) {
                    throw new IOException("Unable to write to the non-blocking channel. " + ioe.getLocalizedMessage());
                }
                finally {
                    this.bb.clear();
                }
            } else {
                throw new IOException("Unable to write. Null byte buffer or channel detected.");
            }
        }

        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }
    }

    private static final class NbChannelInputStream
    extends InputStream {
        private ByteBuffer bb;
        private ReadableByteChannel channel;
        private boolean endReached;
        private SelectableChannel selectableChannel;

        public NbChannelInputStream(ReadableByteChannel channel) {
            this.channel = channel;
            this.selectableChannel = (SelectableChannel)((Object)channel);
            this.bb = ByteBuffer.allocate(8192);
            this.bb.flip();
            this.endReached = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            int result = 0;
            Selector selector = null;
            SelectionKey selectionKey = null;
            try {
                if (this.bb.hasRemaining()) {
                    result = this.bb.get();
                } else if (!this.endReached) {
                    int bytesRead = this.readChannel();
                    if (bytesRead == 0) {
                        selector = SelectorFactory.getSelector();
                        if (selector != null) {
                            selectionKey = this.selectableChannel.register(selector, 1);
                            selector.select(10000L);
                        }
                        bytesRead = this.readChannel();
                    } else if (bytesRead == -1) {
                        this.endReached = true;
                    }
                    result = this.bb.remaining() == 0 ? -1 : (int)this.bb.get();
                } else {
                    result = -1;
                }
            }
            finally {
                if (selectionKey != null) {
                    selectionKey.cancel();
                    if (selector != null) {
                        selector.selectNow();
                        SelectorFactory.returnSelector(selector);
                    }
                }
            }
            return result;
        }

        private int readChannel() throws IOException {
            int result = 0;
            this.bb.clear();
            result = this.channel.read(this.bb);
            this.bb.flip();
            return result;
        }
    }
}

